/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.solidity;

import com.alaya.abi.solidity.TypeDecoder;
import com.alaya.abi.solidity.TypeReference;
import com.alaya.abi.solidity.datatypes.Array;
import com.alaya.abi.solidity.datatypes.Bytes;
import com.alaya.abi.solidity.datatypes.BytesType;
import com.alaya.abi.solidity.datatypes.DynamicArray;
import com.alaya.abi.solidity.datatypes.DynamicBytes;
import com.alaya.abi.solidity.datatypes.StaticArray;
import com.alaya.abi.solidity.datatypes.Type;
import com.alaya.abi.solidity.datatypes.Utf8String;
import com.alaya.abi.solidity.datatypes.generated.Bytes32;
import com.alaya.utils.Numeric;
import com.alaya.utils.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FunctionReturnDecoder {
    private FunctionReturnDecoder() {
    }

    public static List<Type> decode(String rawInput, List<TypeReference<Type>> outputParameters, long chainId) {
        String input = Numeric.cleanHexPrefix((String)rawInput);
        if (Strings.isEmpty((String)input)) {
            return Collections.emptyList();
        }
        return FunctionReturnDecoder.build(input, outputParameters, chainId);
    }

    public static <T extends Type> Type decodeIndexedValue(String rawInput, TypeReference<T> typeReference, long chainId) {
        String input = Numeric.cleanHexPrefix((String)rawInput);
        try {
            Class<T> type = typeReference.getClassType();
            if (Bytes.class.isAssignableFrom(type)) {
                return TypeDecoder.decodeBytes(input, Class.forName(type.getName()));
            }
            if (Array.class.isAssignableFrom(type) || BytesType.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
                return TypeDecoder.decodeBytes(input, Bytes32.class);
            }
            return TypeDecoder.decode(input, type, chainId);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static List<Type> build(String input, List<TypeReference<Type>> outputParameters, long chainId) {
        ArrayList<Type> results = new ArrayList<Type>(outputParameters.size());
        int offset = 0;
        for (TypeReference<Type> typeReference : outputParameters) {
            try {
                int length;
                Type result;
                Class<Type> type = typeReference.getClassType();
                int hexStringDataOffset = FunctionReturnDecoder.getDataOffset(input, offset, type, chainId);
                if (DynamicArray.class.isAssignableFrom(type)) {
                    result = TypeDecoder.decodeDynamicArray(input, hexStringDataOffset, typeReference, chainId);
                    offset += 64;
                } else if (typeReference instanceof TypeReference.StaticArrayTypeReference) {
                    length = ((TypeReference.StaticArrayTypeReference)typeReference).getSize();
                    result = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length, chainId);
                    offset += length * 64;
                } else if (StaticArray.class.isAssignableFrom(type)) {
                    length = Integer.parseInt(type.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                    result = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length, chainId);
                    offset += length * 64;
                } else {
                    result = TypeDecoder.decode(input, hexStringDataOffset, type, chainId);
                    offset += 64;
                }
                results.add(result);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Invalid class reference provided", e);
            }
        }
        return results;
    }

    private static <T extends Type> int getDataOffset(String input, int offset, Class<T> type, long chainId) {
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type) || DynamicArray.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeUintAsInt(input, offset, chainId) << 1;
        }
        return offset;
    }
}

