/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.solidity;

import com.alaya.abi.solidity.datatypes.IntType;
import com.alaya.abi.solidity.datatypes.NumericType;
import com.alaya.abi.solidity.datatypes.Type;
import com.alaya.abi.solidity.datatypes.Ufixed;
import com.alaya.abi.solidity.datatypes.Uint;
import com.alaya.abi.solidity.datatypes.Utf8String;
import com.alaya.utils.Numeric;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.util.encoders.Hex;

public class PlatOnTypeEncoder {
    private PlatOnTypeEncoder() {
    }

    public static String encode(Type parameter) {
        if (parameter instanceof IntType) {
            return PlatOnTypeEncoder.encodeInt((IntType)parameter);
        }
        if (parameter instanceof Utf8String) {
            return PlatOnTypeEncoder.encodeString((Utf8String)parameter);
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + parameter.getClass());
    }

    private static String encodeInt(IntType intType) {
        byte[] rawValue = PlatOnTypeEncoder.toByteArray(intType);
        byte paddingValue = PlatOnTypeEncoder.getPaddingValue(intType);
        byte[] paddedRawValue = new byte[intType.getBitSize() / 8];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, paddedRawValue.length - rawValue.length, rawValue.length);
        return Numeric.toHexStringNoPrefix((byte[])paddedRawValue);
    }

    private static String encodeString(Utf8String string) {
        byte[] utfEncoded = string.getValue().getBytes(StandardCharsets.UTF_8);
        return Hex.toHexString((byte[])utfEncoded);
    }

    private static byte getPaddingValue(NumericType numericType) {
        if (numericType.getValue().signum() == -1) {
            return -1;
        }
        return 0;
    }

    private static byte[] toByteArray(NumericType numericType) {
        BigInteger value = numericType.getValue();
        if ((numericType instanceof Ufixed || numericType instanceof Uint) && value.bitLength() == 256) {
            byte[] byteArray = new byte[32];
            System.arraycopy(value.toByteArray(), 1, byteArray, 0, 32);
            return byteArray;
        }
        return value.toByteArray();
    }
}

