/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.solidity.datatypes;

import com.alaya.abi.solidity.TypeReference;
import com.alaya.abi.solidity.Utils;
import com.alaya.abi.solidity.datatypes.Type;
import java.util.List;
import java.util.stream.Collectors;

public class Event {
    private String name;
    private int functionType;
    private List<TypeReference<Type>> parameters;

    public Event(String name, List<TypeReference<?>> parameters) {
        this.name = name;
        this.parameters = Utils.convert(parameters);
    }

    public Event(int functionType, List<TypeReference<?>> parameters) {
        this.functionType = functionType;
        this.parameters = Utils.convert(parameters);
    }

    public String getName() {
        return this.name;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public List<TypeReference<Type>> getParameters() {
        return this.parameters;
    }

    public List<TypeReference<Type>> getIndexedParameters() {
        return this.parameters.stream().filter(TypeReference::isIndexed).collect(Collectors.toList());
    }

    public List<TypeReference<Type>> getNonIndexedParameters() {
        return this.parameters.stream().filter(p -> !p.isIndexed()).collect(Collectors.toList());
    }
}

