/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.rlp.wasm;

import com.alaya.rlp.wasm.Container;
import com.alaya.rlp.wasm.ContainerType;
import com.alaya.rlp.wasm.MapContainer;
import com.alaya.rlp.wasm.PairContainer;
import com.alaya.rlp.wasm.datatypes.Pair;
import java.util.Collection;
import java.util.Map;

public class CollectionContainer<C extends Collection<T>, T>
implements Container<T> {
    Class collectionType;
    Container contentType;

    @Override
    public ContainerType getType() {
        return ContainerType.COLLECTION;
    }

    CollectionContainer(Class collectionType) {
        this.collectionType = collectionType;
    }

    @Override
    public Class<T> asRaw() {
        throw new RuntimeException("not a raw type");
    }

    @Override
    public CollectionContainer<C, T> asCollection() {
        return this;
    }

    @Override
    public MapContainer<? extends Map<?, T>, ?, T> asMap() {
        throw new RuntimeException("not a map container");
    }

    @Override
    public PairContainer<? extends Pair<?, T>, ?, T> asPair() {
        throw new RuntimeException("not a pair container");
    }

    public static <C extends Collection<T>, T> CollectionContainerBuilder<C, T> builder() {
        return new CollectionContainerBuilder();
    }

    public CollectionContainer() {
    }

    public CollectionContainer(Class collectionType, Container contentType) {
        this.collectionType = collectionType;
        this.contentType = contentType;
    }

    public static class CollectionContainerBuilder<C extends Collection<T>, T> {
        private Class collectionType;
        private Container contentType;

        CollectionContainerBuilder() {
        }

        public CollectionContainerBuilder<C, T> collectionType(Class collectionType) {
            this.collectionType = collectionType;
            return this;
        }

        public CollectionContainerBuilder<C, T> contentType(Container contentType) {
            this.contentType = contentType;
            return this;
        }

        public CollectionContainer<C, T> build() {
            return new CollectionContainer(this.collectionType, this.contentType);
        }

        public String toString() {
            return "CollectionContainer.CollectionContainerBuilder(collectionType=" + this.collectionType + ", contentType=" + this.contentType + ")";
        }
    }
}

