/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.rlp.wasm;

import com.alaya.rlp.wasm.RLPCodec;
import com.alaya.rlp.wasm.RLPEncoder;
import com.alaya.rlp.wasm.RLPItem;
import com.alaya.rlp.wasm.RLPList;
import com.alaya.rlp.wasm.RLPParser;
import com.alaya.rlp.wasm.RLPUtils;
import com.alaya.rlp.wasm.datatypes.Int128;
import com.alaya.rlp.wasm.datatypes.Int16;
import com.alaya.rlp.wasm.datatypes.Int32;
import com.alaya.rlp.wasm.datatypes.Int64;
import com.alaya.rlp.wasm.datatypes.Int8;
import com.alaya.rlp.wasm.datatypes.Uint128;
import com.alaya.rlp.wasm.datatypes.Uint16;
import com.alaya.rlp.wasm.datatypes.Uint32;
import com.alaya.rlp.wasm.datatypes.Uint64;
import com.alaya.rlp.wasm.datatypes.Uint8;
import com.alaya.rlp.wasm.datatypes.WasmAddress;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface RLPElement {
    public boolean isRLPList();

    public boolean isRLPItem();

    public RLPList asRLPList();

    public RLPItem asRLPItem();

    public boolean isNull();

    public byte[] getEncoded();

    public byte[] asBytes();

    public byte asByte();

    public short asShort();

    public int asInt();

    public long asLong();

    public int size();

    public RLPElement get(int var1);

    public boolean add(RLPElement var1);

    public RLPElement set(int var1, RLPElement var2);

    public BigInteger asBigInteger();

    public String asString();

    public boolean asBoolean();

    default public <T> T as(Class<T> clazz, long chainId) {
        return RLPCodec.decode(this, clazz, chainId);
    }

    public static RLPElement fromEncoded(byte[] data) {
        return RLPElement.fromEncoded(data, true);
    }

    public static RLPElement fromEncoded(byte[] data, boolean lazy) {
        return RLPParser.fromEncoded(data, lazy);
    }

    public static RLPElement readRLPTree(Object t) {
        if (t == null) {
            return RLPItem.NULL;
        }
        if (t.getClass() == Boolean.TYPE || t instanceof Boolean) {
            return (Boolean)t != false ? RLPItem.ONE : RLPItem.NULL;
        }
        if (t instanceof RLPElement) {
            return (RLPElement)t;
        }
        RLPEncoder encoder = RLPUtils.getAnnotatedRLPEncoder(t.getClass());
        if (encoder != null) {
            return encoder.encode(t);
        }
        if (t instanceof BigInteger) {
            return RLPItem.fromBigInteger((BigInteger)t);
        }
        if (t instanceof Int8) {
            return RLPItem.fromBigInteger(((Int8)t).getUnsingedValue());
        }
        if (t instanceof Int16) {
            return RLPItem.fromBigInteger(((Int16)t).getUnsingedValue());
        }
        if (t instanceof Int32) {
            return RLPItem.fromBigInteger(((Int32)t).getUnsingedValue());
        }
        if (t instanceof Int64) {
            return RLPItem.fromBigInteger(((Int64)t).getUnsingedValue());
        }
        if (t instanceof Int128) {
            return RLPItem.fromBigInteger(((Int128)t).getUnsingedValue());
        }
        if (t instanceof Uint8) {
            return RLPItem.fromBigInteger(((Uint8)t).getValue());
        }
        if (t instanceof Uint16) {
            return RLPItem.fromBigInteger(((Uint16)t).getValue());
        }
        if (t instanceof Uint32) {
            return RLPItem.fromBigInteger(((Uint32)t).getValue());
        }
        if (t instanceof Uint64) {
            return RLPItem.fromBigInteger(((Uint64)t).getValue());
        }
        if (t instanceof Uint128) {
            return RLPItem.fromBigInteger(((Uint128)t).getValue());
        }
        if (t instanceof byte[]) {
            return RLPItem.fromBytes((byte[])t);
        }
        if (t instanceof WasmAddress) {
            return RLPItem.fromBytes(((WasmAddress)t).getValue());
        }
        if (t instanceof String) {
            return RLPItem.fromString((String)t);
        }
        if (t.getClass() == Byte.TYPE || t instanceof Byte) {
            return RLPItem.fromByte((Byte)t);
        }
        if (t.getClass() == Short.TYPE || t instanceof Short) {
            return RLPItem.fromShort((Short)t);
        }
        if (t.getClass() == Integer.TYPE || t instanceof Integer) {
            return RLPItem.fromInt((Integer)t);
        }
        if (t.getClass() == Long.TYPE || t instanceof Long) {
            return RLPItem.fromLong((Long)t);
        }
        if (t.getClass() == Float.TYPE || t instanceof Float) {
            return RLPItem.fromBigInteger(new BigInteger(Integer.toUnsignedString(Float.floatToIntBits(((Float)t).floatValue()))));
        }
        if (t.getClass() == Double.TYPE || t instanceof Double) {
            return RLPItem.fromBigInteger(new BigInteger(Long.toUnsignedString(Double.doubleToLongBits((Double)t))));
        }
        if (t instanceof Map) {
            return RLPCodec.encodeMap((Map)t);
        }
        if (t.getClass().isArray()) {
            RLPList list = RLPList.createEmpty(Array.getLength(t));
            for (int i = 0; i < Array.getLength(t); ++i) {
                list.add(RLPElement.readRLPTree(Array.get(t, i)));
            }
            return list;
        }
        if (t instanceof Collection) {
            return RLPCodec.encodeCollection((Collection)t, null);
        }
        List<Field> fields = RLPUtils.getRLPFields(t.getClass());
        if (fields.size() == 0) {
            throw new RuntimeException("no encodable field of " + t.getClass().getName() + " found");
        }
        return new RLPList(fields.stream().map(f -> {
            Object o;
            f.setAccessible(true);
            try {
                o = f.get(t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (o == null) {
                return RLPItem.NULL;
            }
            RLPEncoder fieldEncoder = RLPUtils.getAnnotatedRLPEncoder(f);
            if (fieldEncoder != null) {
                return fieldEncoder.encode(o);
            }
            Comparator comparator = RLPUtils.getKeyOrdering(f);
            if (Set.class.isAssignableFrom(f.getType())) {
                return RLPCodec.encodeCollection((Collection)o, comparator);
            }
            comparator = RLPUtils.getKeyOrdering(f);
            if (Map.class.isAssignableFrom(f.getType())) {
                Map m = (Map)o;
                return RLPCodec.encodeMap(m);
            }
            return RLPElement.readRLPTree(o);
        }).collect(Collectors.toList()));
    }
}

