/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.rlp.wasm.datatypes;

import com.alaya.rlp.wasm.datatypes.Int;
import java.math.BigInteger;

public class Int64
extends Int {
    public long value;
    public static final int size = 64;

    private Int64(long value) {
        this.value = value;
        this.unsingedValue = new BigInteger(Long.toUnsignedString(Int64.encodeZigZag64(value)));
    }

    private Int64(BigInteger unsingedValue) {
        this.unsingedValue = unsingedValue;
        this.value = Int64.decodeZigZag64(unsingedValue.longValue());
    }

    public static Int64 of(long value) {
        return new Int64(value);
    }

    public static Int64 ofUnsignedValue(BigInteger unsingedValue) {
        return new Int64(unsingedValue);
    }

    public static Int64 of(BigInteger value) {
        if (value.bitLength() >= 64) {
            throw new UnsupportedOperationException("Data length overflow, Bitsize must be in range 0 < bitSize < 64");
        }
        return new Int64(Int64.encodeZigZag(value, 64));
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Int64 that = (Int64)o;
        return this.value == that.value;
    }

    public String toString() {
        return Long.valueOf(this.value).toString();
    }
}

