/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.rlp.wasm.datatypes;

import java.math.BigInteger;

public abstract class Uint {
    public BigInteger value;
    private int bitSize;

    public Uint(int bitSize, BigInteger value) {
        if (!this.valid(bitSize, value)) {
            throw new UnsupportedOperationException("Data length overflow, Bitsize must be in range 0 < bitSize <=" + bitSize);
        }
        if (value.compareTo(BigInteger.ZERO) < 0) {
            throw new UnsupportedOperationException("Negative numbers are not allowed");
        }
        this.value = value;
        this.bitSize = bitSize;
    }

    private boolean valid(int bitSize, BigInteger value) {
        return value.bitLength() <= bitSize;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BigInteger value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Uint that = (Uint)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public String toString() {
        return this.value.toString();
    }
}

