/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.rlp.wasm.datatypes;

import com.alaya.bech32.Bech32;
import com.alaya.parameters.NetworkParameters;
import com.alaya.utils.Numeric;
import java.math.BigInteger;
import java.util.Objects;

public class WasmAddress {
    private byte[] value;
    private BigInteger bigIntValue;
    private String address;
    public static final int LENGTH = 160;
    public static final int LENGTH_IN_HEX = 40;

    public WasmAddress(byte[] value) {
        this(value, NetworkParameters.CurrentNetwork.getHrp());
    }

    public WasmAddress(byte[] value, long chainId) {
        this(value, NetworkParameters.getHrp((long)chainId));
    }

    public WasmAddress(byte[] value, String hrp) {
        this.value = value;
        this.bigIntValue = Numeric.toBigInt((byte[])value);
        this.address = Bech32.addressEncode((String)hrp, (String)Numeric.toHexStringWithPrefixZeroPadded((BigInteger)this.bigIntValue, (int)40));
    }

    public WasmAddress(String bechValue) {
        this.value = Numeric.hexStringToByteArray((String)Bech32.addressDecodeHex((String)bechValue));
        this.bigIntValue = Numeric.toBigInt((byte[])this.value);
        this.address = bechValue;
    }

    public WasmAddress(BigInteger value) {
        this(value.toByteArray());
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getAddress() {
        return this.address;
    }

    public BigInteger getBigIntValue() {
        return this.bigIntValue;
    }

    public String toString() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WasmAddress address = (WasmAddress)o;
        return Objects.equals(this.bigIntValue, address.bigIntValue);
    }

    public int hashCode() {
        return Objects.hash(this.bigIntValue);
    }
}

