/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.crypto;

import com.alaya.bech32.Bech32;
import com.alaya.crypto.ECKeyPair;
import com.alaya.crypto.Keys;
import com.alaya.parameters.NetworkParameters;
import com.alaya.utils.Numeric;
import java.util.Objects;

public class Credentials {
    private final ECKeyPair ecKeyPair;
    private final String latAddress;
    private final String laxAddress;

    private Credentials(ECKeyPair ecKeyPair, String latAddress, String laxAddress) {
        this.ecKeyPair = ecKeyPair;
        this.latAddress = latAddress;
        this.laxAddress = laxAddress;
    }

    public ECKeyPair getEcKeyPair() {
        return this.ecKeyPair;
    }

    public String getAddress(NetworkParameters networkParameters) {
        networkParameters.getHrp();
        if (NetworkParameters.Hrp.ATP.getHrp().equals(networkParameters.getHrp())) {
            return this.latAddress;
        }
        return this.laxAddress;
    }

    public String getAddress(long chainId) {
        if (NetworkParameters.MainNetParams.getChainId() == chainId) {
            return this.latAddress;
        }
        return this.laxAddress;
    }

    public String getAddress() {
        if (NetworkParameters.CurrentNetwork.getChainId() == NetworkParameters.MainNetParams.getChainId()) {
            return this.latAddress;
        }
        return this.laxAddress;
    }

    public static Credentials create(ECKeyPair ecKeyPair) {
        String address = Numeric.prependHexPrefix((String)Keys.getAddress(ecKeyPair));
        String latAddress = Bech32.addressEncode((String)NetworkParameters.Hrp.ATP.getHrp(), (String)address);
        String laxAddress = Bech32.addressEncode((String)NetworkParameters.Hrp.ATX.getHrp(), (String)address);
        return new Credentials(ecKeyPair, latAddress, laxAddress);
    }

    public static Credentials create(String privateKey, String publicKey) {
        return Credentials.create(new ECKeyPair(Numeric.toBigInt((String)privateKey), Numeric.toBigInt((String)publicKey)));
    }

    public static Credentials create(String privateKey) {
        return Credentials.create(ECKeyPair.create(Numeric.toBigInt((String)privateKey)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credentials that = (Credentials)o;
        return Objects.equals(this.ecKeyPair, that.ecKeyPair) && Objects.equals(this.latAddress, that.latAddress) && Objects.equals(this.laxAddress, that.laxAddress);
    }

    public int hashCode() {
        return Objects.hash(this.ecKeyPair, this.latAddress, this.laxAddress);
    }
}

