/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.crypto;

import com.alaya.bech32.Bech32;
import com.alaya.crypto.Credentials;
import com.alaya.crypto.RawTransaction;
import com.alaya.crypto.Sign;
import com.alaya.rlp.solidity.RlpEncoder;
import com.alaya.rlp.solidity.RlpList;
import com.alaya.rlp.solidity.RlpString;
import com.alaya.rlp.solidity.RlpType;
import com.alaya.utils.Bytes;
import com.alaya.utils.Numeric;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class TransactionEncoder {
    private static final int CHAIN_ID_INC = 35;
    private static final int LOWER_REAL_V = 27;

    public static byte[] signMessage(RawTransaction rawTransaction, Credentials credentials) {
        byte[] encodedTransaction = TransactionEncoder.encode(rawTransaction);
        Sign.SignatureData signatureData = Sign.signMessage(encodedTransaction, credentials.getEcKeyPair());
        return TransactionEncoder.encode(rawTransaction, signatureData);
    }

    public static byte[] signMessage(RawTransaction rawTransaction, long chainId, Credentials credentials) {
        byte[] encodedTransaction = TransactionEncoder.encode(rawTransaction, chainId);
        Sign.SignatureData signatureData = Sign.signMessage(encodedTransaction, credentials.getEcKeyPair());
        Sign.SignatureData eip155SignatureData = TransactionEncoder.createEip155SignatureData(signatureData, chainId);
        return TransactionEncoder.encode(rawTransaction, eip155SignatureData);
    }

    public static Sign.SignatureData createEip155SignatureData(Sign.SignatureData signatureData, long chainId) {
        BigInteger v = Numeric.toBigInt((byte[])signatureData.getV());
        v = v.subtract(BigInteger.valueOf(27L));
        v = v.add(BigInteger.valueOf(chainId * 2L));
        v = v.add(BigInteger.valueOf(35L));
        return new Sign.SignatureData(v.toByteArray(), signatureData.getR(), signatureData.getS());
    }

    public static byte[] encode(RawTransaction rawTransaction) {
        return TransactionEncoder.encode(rawTransaction, null);
    }

    public static byte[] encode(RawTransaction rawTransaction, long chainId) {
        Sign.SignatureData signatureData = new Sign.SignatureData(TransactionEncoder.longToBytes(chainId), new byte[0], new byte[0]);
        return TransactionEncoder.encode(rawTransaction, signatureData);
    }

    private static byte[] encode(RawTransaction rawTransaction, Sign.SignatureData signatureData) {
        List<RlpType> values = TransactionEncoder.asRlpValues(rawTransaction, signatureData);
        RlpList rlpList = new RlpList(values);
        return RlpEncoder.encode((RlpType)rlpList);
    }

    private static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    static List<RlpType> asRlpValues(RawTransaction rawTransaction, Sign.SignatureData signatureData) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((BigInteger)rawTransaction.getNonce()));
        result.add((RlpType)RlpString.create((BigInteger)rawTransaction.getGasPrice()));
        result.add((RlpType)RlpString.create((BigInteger)rawTransaction.getGasLimit()));
        String to = rawTransaction.getTo();
        if (to != null && to.length() > 0) {
            result.add((RlpType)RlpString.create((byte[])Bech32.addressDecode((String)to)));
        } else {
            result.add((RlpType)RlpString.create((String)""));
        }
        result.add((RlpType)RlpString.create((BigInteger)rawTransaction.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)rawTransaction.getData());
        result.add((RlpType)RlpString.create((byte[])data));
        if (signatureData != null) {
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getV())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getR())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getS())));
        }
        return result;
    }
}

