/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.crypto;

import com.alaya.bech32.Bech32;
import com.alaya.crypto.Bip39Wallet;
import com.alaya.crypto.CipherException;
import com.alaya.crypto.Credentials;
import com.alaya.crypto.ECKeyPair;
import com.alaya.crypto.Hash;
import com.alaya.crypto.Keys;
import com.alaya.crypto.MnemonicUtils;
import com.alaya.crypto.SecureRandomUtils;
import com.alaya.crypto.Wallet;
import com.alaya.crypto.WalletFile;
import com.alaya.utils.Files;
import com.alaya.utils.Numeric;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.util.encoders.Hex;

public class WalletUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final SecureRandom secureRandom = SecureRandomUtils.secureRandom();
    private static final Pattern OLD_ADDRESS_PATTERN;

    public static String generateFullNewWalletFile(String password, File destinationDirectory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CipherException, IOException {
        return WalletUtils.generateNewWalletFile(password, destinationDirectory, true);
    }

    public static String generateLightNewWalletFile(String password, File destinationDirectory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CipherException, IOException {
        return WalletUtils.generateNewWalletFile(password, destinationDirectory, false);
    }

    public static String generatePlatONWalletFile(String password, File destinationDirectory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CipherException, IOException {
        ECKeyPair ecKeyPair = Keys.createEcKeyPair();
        String fileName = WalletUtils.generatePlatONWalletFile(password, ecKeyPair, destinationDirectory);
        return fileName;
    }

    public static Bip39Wallet generatePlatONBip39Wallet(String password, File destinationDirectory) throws CipherException, IOException {
        byte[] initialEntropy = new byte[16];
        secureRandom.nextBytes(initialEntropy);
        String mnemonic = MnemonicUtils.generateMnemonic(initialEntropy);
        byte[] seed = MnemonicUtils.generateSeed(mnemonic, password);
        ECKeyPair ecKeyPair = ECKeyPair.create(Hash.sha256((byte[])seed));
        String fileName = WalletUtils.generatePlatONWalletFile(password, ecKeyPair, destinationDirectory);
        return new Bip39Wallet(fileName, mnemonic);
    }

    public static String generatePlatONWalletFile(String password, ECKeyPair ecKeyPair, File destinationDirectory) throws CipherException, IOException {
        WalletFile walletFile = Wallet.createPlatON(password, ecKeyPair);
        String fileName = WalletUtils.getWalletFileName(walletFile);
        File destination = new File(destinationDirectory, fileName);
        objectMapper.writeValue(destination, (Object)walletFile);
        return fileName;
    }

    public static String generateNewWalletFile(String password, File destinationDirectory) throws CipherException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        return WalletUtils.generateFullNewWalletFile(password, destinationDirectory);
    }

    public static String generateNewWalletFile(String password, File destinationDirectory, boolean useFullScrypt) throws CipherException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        ECKeyPair ecKeyPair = Keys.createEcKeyPair();
        return WalletUtils.generateWalletFile(password, ecKeyPair, destinationDirectory, useFullScrypt);
    }

    public static String generateWalletFile(String password, ECKeyPair ecKeyPair, File destinationDirectory, boolean useFullScrypt) throws CipherException, IOException {
        WalletFile walletFile = useFullScrypt ? Wallet.createStandard(password, ecKeyPair) : Wallet.createLight(password, ecKeyPair);
        String fileName = WalletUtils.getWalletFileName(walletFile);
        File destination = new File(destinationDirectory, fileName);
        objectMapper.writeValue(destination, (Object)walletFile);
        return fileName;
    }

    public static Bip39Wallet generateBip39Wallet(String password, File destinationDirectory) throws CipherException, IOException {
        byte[] initialEntropy = new byte[16];
        secureRandom.nextBytes(initialEntropy);
        String mnemonic = MnemonicUtils.generateMnemonic(initialEntropy);
        byte[] seed = MnemonicUtils.generateSeed(mnemonic, password);
        ECKeyPair privateKey = ECKeyPair.create(Hash.sha256((byte[])seed));
        String walletFile = WalletUtils.generateWalletFile(password, privateKey, destinationDirectory, false);
        return new Bip39Wallet(walletFile, mnemonic);
    }

    public static Credentials loadCredentials(String password, String source) throws IOException, CipherException {
        return WalletUtils.loadCredentials(password, new File(source));
    }

    public static Credentials loadCredentials(String password, File source) throws IOException, CipherException {
        WalletFile walletFile;
        String fileContent = Files.readString((File)source);
        Matcher matcher = OLD_ADDRESS_PATTERN.matcher(fileContent);
        if (!matcher.find()) {
            walletFile = (WalletFile)objectMapper.readValue(fileContent, WalletFile.class);
        } else {
            String fileContent2 = fileContent.replaceFirst("address\":.*?,", "address\":{},");
            walletFile = (WalletFile)objectMapper.readValue(fileContent2, WalletFile.class);
        }
        return Credentials.create(Wallet.decrypt(password, walletFile));
    }

    public static Credentials loadBip39Credentials(String password, String mnemonic) {
        byte[] seed = MnemonicUtils.generateSeed(mnemonic, password);
        return Credentials.create(ECKeyPair.create(Hash.sha256((byte[])seed)));
    }

    private static String getWalletFileName(WalletFile walletFile) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("'UTC--'yyyy-MM-dd'T'HH-mm-ss.nVV'--'");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        return now.format(format) + walletFile.getAddress().getMainnet() + ".json";
    }

    public static String getDefaultKeyDirectory() {
        return WalletUtils.getDefaultKeyDirectory(System.getProperty("os.name"));
    }

    static String getDefaultKeyDirectory(String osName1) {
        String osName = osName1.toLowerCase();
        if (osName.startsWith("mac")) {
            return String.format("%s%sLibrary%sEthereum", System.getProperty("user.home"), File.separator, File.separator);
        }
        if (osName.startsWith("win")) {
            return String.format("%s%sEthereum", System.getenv("APPDATA"), File.separator);
        }
        return String.format("%s%s.ethereum", System.getProperty("user.home"), File.separator);
    }

    public static String getTestnetKeyDirectory() {
        return String.format("%s%stestnet%skeystore", WalletUtils.getDefaultKeyDirectory(), File.separator, File.separator);
    }

    public static String getMainnetKeyDirectory() {
        return String.format("%s%skeystore", WalletUtils.getDefaultKeyDirectory(), File.separator);
    }

    public static String getRinkebyKeyDirectory() {
        return String.format("%s%srinkeby%skeystore", WalletUtils.getDefaultKeyDirectory(), File.separator, File.separator);
    }

    public static boolean isValidPrivateKey(String privateKey) {
        String cleanPrivateKey = Numeric.cleanHexPrefix((String)privateKey);
        return cleanPrivateKey.length() == 64;
    }

    public static boolean isValidAddress(String input) {
        String cleanInput;
        try {
            byte[] bytes = Bech32.addressDecode((String)input);
            String hexAddress = Hex.toHexString((byte[])bytes);
            cleanInput = Numeric.cleanHexPrefix((String)hexAddress);
        }
        catch (Exception e) {
            return false;
        }
        try {
            Numeric.toBigIntNoPrefix((String)cleanInput);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return cleanInput.length() == 40;
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OLD_ADDRESS_PATTERN = Pattern.compile(".*address\":[\\s]*\".*");
    }
}

