/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.solidity;

import com.alaya.abi.solidity.FunctionEncoder;
import com.alaya.abi.solidity.datatypes.Bool;
import com.alaya.abi.solidity.datatypes.DynamicArray;
import com.alaya.abi.solidity.datatypes.DynamicBytes;
import com.alaya.abi.solidity.datatypes.Function;
import com.alaya.abi.solidity.datatypes.Type;
import com.alaya.abi.solidity.datatypes.Uint;
import com.alaya.abi.solidity.datatypes.Utf8String;
import com.alaya.abi.solidity.datatypes.generated.Bytes10;
import com.alaya.abi.solidity.datatypes.generated.Uint32;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FunctionEncoderTest {
    @Test
    public void testBuildMethodId() {
        Assert.assertThat((Object)FunctionEncoder.buildMethodId((String)"baz(uint32,bool)"), (Matcher)CoreMatchers.is((Object)"0xcdcd77c0"));
    }

    @Test
    public void testBuildMessageSignature() {
        Assert.assertThat((Object)FunctionEncoder.buildMethodSignature((String)"baz", Arrays.asList(new Uint32(BigInteger.valueOf(69L)), new Bool(true))), (Matcher)CoreMatchers.is((Object)"baz(uint32,bool)"));
    }

    @Test
    public void testBuildEmptyMethodSignature() {
        Assert.assertThat((Object)FunctionEncoder.buildMethodSignature((String)"empty", Collections.emptyList()), (Matcher)CoreMatchers.is((Object)"empty()"));
    }

    @Test
    public void testEncodeConstructorEmpty() {
        Assert.assertThat((Object)FunctionEncoder.encodeConstructor(Collections.emptyList()), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void testEncodeConstructorString() {
        Assert.assertThat((Object)FunctionEncoder.encodeConstructor(Collections.singletonList(new Utf8String("Greetings!"))), (Matcher)CoreMatchers.is((Object)"0000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000a4772656574696e67732100000000000000000000000000000000000000000000"));
    }

    @Test
    public void testEncodeConstructorUint() {
        Assert.assertThat((Object)FunctionEncoder.encodeConstructor(Arrays.asList(new Uint(BigInteger.ONE), new Uint(BigInteger.valueOf(32L)))), (Matcher)CoreMatchers.is((Object)"00000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000020"));
    }

    @Test
    public void testFunctionSimpleEncode() {
        Function function = new Function("baz", Arrays.asList(new Uint32(BigInteger.valueOf(69L)), new Bool(true)), Collections.emptyList());
        Assert.assertThat((Object)FunctionEncoder.encode((Function)function), (Matcher)CoreMatchers.is((Object)"0xcdcd77c000000000000000000000000000000000000000000000000000000000000000450000000000000000000000000000000000000000000000000000000000000001"));
    }

    @Test
    public void testFunctionMDynamicArrayEncode1() {
        Function function = new Function("sam", Arrays.asList(new DynamicBytes("dave".getBytes()), new Bool(true), new DynamicArray((Type[])new Uint[]{new Uint(BigInteger.ONE), new Uint(BigInteger.valueOf(2L)), new Uint(BigInteger.valueOf(3L))})), Collections.emptyList());
        Assert.assertThat((Object)FunctionEncoder.encode((Function)function), (Matcher)CoreMatchers.is((Object)"0xa5643bf20000000000000000000000000000000000000000000000000000000000000060000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000a0000000000000000000000000000000000000000000000000000000000000000464617665000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000003"));
    }

    @Test
    public void testFunctionMDynamicArrayEncode2() {
        Function function = new Function("f", Arrays.asList(new Uint(BigInteger.valueOf(291L)), new DynamicArray((Type[])new Uint32[]{new Uint32(BigInteger.valueOf(1110L)), new Uint32(BigInteger.valueOf(1929L))}), new Bytes10("1234567890".getBytes()), new DynamicBytes("Hello, world!".getBytes())), Collections.emptyList());
        Assert.assertThat((Object)FunctionEncoder.encode((Function)function), (Matcher)CoreMatchers.is((Object)"0x8be6524600000000000000000000000000000000000000000000000000000000000001230000000000000000000000000000000000000000000000000000000000000080313233343536373839300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e0000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000004560000000000000000000000000000000000000000000000000000000000000789000000000000000000000000000000000000000000000000000000000000000d48656c6c6f2c20776f726c642100000000000000000000000000000000000000"));
    }
}

