/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.solidity;

import com.alaya.abi.solidity.TypeEncoder;
import com.alaya.abi.solidity.datatypes.Address;
import com.alaya.abi.solidity.datatypes.Array;
import com.alaya.abi.solidity.datatypes.Bool;
import com.alaya.abi.solidity.datatypes.BytesType;
import com.alaya.abi.solidity.datatypes.DynamicArray;
import com.alaya.abi.solidity.datatypes.DynamicBytes;
import com.alaya.abi.solidity.datatypes.Int;
import com.alaya.abi.solidity.datatypes.NumericType;
import com.alaya.abi.solidity.datatypes.Type;
import com.alaya.abi.solidity.datatypes.Ufixed;
import com.alaya.abi.solidity.datatypes.Uint;
import com.alaya.abi.solidity.datatypes.Utf8String;
import com.alaya.abi.solidity.datatypes.generated.Bytes1;
import com.alaya.abi.solidity.datatypes.generated.Bytes4;
import com.alaya.abi.solidity.datatypes.generated.Bytes6;
import com.alaya.abi.solidity.datatypes.generated.Int64;
import com.alaya.abi.solidity.datatypes.generated.StaticArray2;
import com.alaya.abi.solidity.datatypes.generated.Uint64;
import java.math.BigInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TypeEncoderTest {
    @Test
    public void testBoolEncode() {
        Assert.assertThat((Object)TypeEncoder.encodeBool((Bool)new Bool(false)), (Matcher)CoreMatchers.is((Object)"0000000000000000000000000000000000000000000000000000000000000000"));
        Assert.assertThat((Object)TypeEncoder.encodeBool((Bool)new Bool(true)), (Matcher)CoreMatchers.is((Object)"0000000000000000000000000000000000000000000000000000000000000001"));
    }

    @Test
    public void testUintEncode() {
        Uint64 zero = new Uint64(BigInteger.ZERO);
        Assert.assertThat((Object)TypeEncoder.encodeNumeric((NumericType)zero), (Matcher)CoreMatchers.is((Object)"0000000000000000000000000000000000000000000000000000000000000000"));
        Uint64 maxLong = new Uint64(BigInteger.valueOf(Long.MAX_VALUE));
        Assert.assertThat((Object)TypeEncoder.encodeNumeric((NumericType)maxLong), (Matcher)CoreMatchers.is((Object)"0000000000000000000000000000000000000000000000007fffffffffffffff"));
        Uint maxValue = new Uint(new BigInteger("ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16));
        Assert.assertThat((Object)TypeEncoder.encodeNumeric((NumericType)maxValue), (Matcher)CoreMatchers.is((Object)"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"));
        Uint largeValue = new Uint(new BigInteger("fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe", 16));
        Assert.assertThat((Object)TypeEncoder.encodeNumeric((NumericType)largeValue), (Matcher)CoreMatchers.is((Object)"fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInvalidUintEncode() {
        new Uint64(BigInteger.valueOf(-1L));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testTooLargeUintEncode() {
        new Uint(new BigInteger("10000000000000000000000000000000000000000000000000000000000000000", 16));
    }

    @Test
    public void testIntEncode() {
        Int64 zero = new Int64(BigInteger.ZERO);
        Assert.assertThat((Object)TypeEncoder.encodeNumeric((NumericType)zero), (Matcher)CoreMatchers.is((Object)"0000000000000000000000000000000000000000000000000000000000000000"));
        Int64 maxLong = new Int64(BigInteger.valueOf(Long.MAX_VALUE));
        Assert.assertThat((Object)TypeEncoder.encodeNumeric((NumericType)maxLong), (Matcher)CoreMatchers.is((Object)"0000000000000000000000000000000000000000000000007fffffffffffffff"));
        Int64 minLong = new Int64(BigInteger.valueOf(Long.MIN_VALUE));
        Assert.assertThat((Object)TypeEncoder.encodeNumeric((NumericType)minLong), (Matcher)CoreMatchers.is((Object)"ffffffffffffffffffffffffffffffffffffffffffffffff8000000000000000"));
        Int minusOne = new Int(BigInteger.valueOf(-1L));
        Assert.assertThat((Object)TypeEncoder.encodeNumeric((NumericType)minusOne), (Matcher)CoreMatchers.is((Object)"ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"));
    }

    @Test
    public void testStaticBytes() {
        Bytes6 staticBytes = new Bytes6(new byte[]{0, 1, 2, 3, 4, 5});
        Assert.assertThat((Object)TypeEncoder.encodeBytes((BytesType)staticBytes), (Matcher)CoreMatchers.is((Object)"0001020304050000000000000000000000000000000000000000000000000000"));
        Bytes1 empty = new Bytes1(new byte[]{0});
        Assert.assertThat((Object)TypeEncoder.encodeBytes((BytesType)empty), (Matcher)CoreMatchers.is((Object)"0000000000000000000000000000000000000000000000000000000000000000"));
        Bytes4 dave = new Bytes4("dave".getBytes());
        Assert.assertThat((Object)TypeEncoder.encodeBytes((BytesType)dave), (Matcher)CoreMatchers.is((Object)"6461766500000000000000000000000000000000000000000000000000000000"));
    }

    @Test
    public void testDynamicBytes() {
        DynamicBytes dynamicBytes = new DynamicBytes(new byte[]{0, 1, 2, 3, 4, 5});
        Assert.assertThat((Object)TypeEncoder.encodeDynamicBytes((DynamicBytes)dynamicBytes), (Matcher)CoreMatchers.is((Object)"00000000000000000000000000000000000000000000000000000000000000060001020304050000000000000000000000000000000000000000000000000000"));
        DynamicBytes empty = new DynamicBytes(new byte[]{0});
        Assert.assertThat((Object)TypeEncoder.encodeDynamicBytes((DynamicBytes)empty), (Matcher)CoreMatchers.is((Object)"00000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000"));
        DynamicBytes dave = new DynamicBytes("dave".getBytes());
        Assert.assertThat((Object)TypeEncoder.encodeDynamicBytes((DynamicBytes)dave), (Matcher)CoreMatchers.is((Object)"00000000000000000000000000000000000000000000000000000000000000046461766500000000000000000000000000000000000000000000000000000000"));
        DynamicBytes loremIpsum = new DynamicBytes("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.".getBytes());
        Assert.assertThat((Object)TypeEncoder.encodeDynamicBytes((DynamicBytes)loremIpsum), (Matcher)CoreMatchers.is((Object)"00000000000000000000000000000000000000000000000000000000000001bd4c6f72656d20697073756d20646f6c6f722073697420616d65742c20636f6e73656374657475722061646970697363696e6720656c69742c2073656420646f20656975736d6f642074656d706f7220696e6369646964756e74207574206c61626f726520657420646f6c6f7265206d61676e6120616c697175612e20557420656e696d206164206d696e696d2076656e69616d2c2071756973206e6f737472756420657865726369746174696f6e20756c6c616d636f206c61626f726973206e69736920757420616c697175697020657820656120636f6d6d6f646f20636f6e7365717561742e2044756973206175746520697275726520646f6c6f7220696e20726570726568656e646572697420696e20766f6c7570746174652076656c697420657373652063696c6c756d20646f6c6f726520657520667567696174206e756c6c612070617269617475722e204578636570746575722073696e74206f6363616563617420637570696461746174206e6f6e2070726f6964656e742c2073756e7420696e2063756c706120717569206f666669636961206465736572756e74206d6f6c6c697420616e696d20696420657374206c61626f72756d2e000000"));
    }

    @Test
    public void testAddress() {
        Address address = new Address("lat1he2z952l8ymnav9f0luvzraapeqw9yec8247zy");
        Assert.assertThat((Object)address.getTypeAsString(), (Matcher)CoreMatchers.is((Object)"address"));
        Assert.assertThat((Object)TypeEncoder.encodeAddress((Address)address), (Matcher)CoreMatchers.is((Object)"000000000000000000000000be5422d15f39373eb0a97ff8c10fbd0e40e29338"));
    }

    @Test
    public void testUtf8String() {
        Utf8String string = new Utf8String("Hello, world!");
        Assert.assertThat((Object)TypeEncoder.encodeString((Utf8String)string), (Matcher)CoreMatchers.is((Object)"000000000000000000000000000000000000000000000000000000000000000d48656c6c6f2c20776f726c642100000000000000000000000000000000000000"));
    }

    @Test
    public void testFixedArray() {
        StaticArray2 array = new StaticArray2((Type[])new Ufixed[]{new Ufixed(BigInteger.valueOf(2L), BigInteger.valueOf(2L)), new Ufixed(BigInteger.valueOf(8L), BigInteger.valueOf(8L))});
        Assert.assertThat((Object)TypeEncoder.encodeArrayValues((Array)array), (Matcher)CoreMatchers.is((Object)"00000000000000000000000000000002200000000000000000000000000000000000000000000000000000000000000880000000000000000000000000000000"));
    }

    @Test
    public void testDynamicArray() {
        DynamicArray array = new DynamicArray((Type[])new Uint[]{new Uint(BigInteger.ONE), new Uint(BigInteger.valueOf(2L)), new Uint(BigInteger.valueOf(3L))});
        Assert.assertThat((Object)TypeEncoder.encodeDynamicArray((DynamicArray)array), (Matcher)CoreMatchers.is((Object)"0000000000000000000000000000000000000000000000000000000000000003000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000003"));
    }

    @Test
    public void testEmptyArray() {
        DynamicArray array = DynamicArray.empty((String)"uint");
        Assert.assertThat((Object)TypeEncoder.encodeDynamicArray((DynamicArray)array), (Matcher)CoreMatchers.is((Object)"0000000000000000000000000000000000000000000000000000000000000000"));
    }
}

