/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.solidity;

import com.alaya.abi.solidity.TypeReference;
import com.alaya.abi.solidity.Utils;
import com.alaya.abi.solidity.datatypes.Bool;
import com.alaya.abi.solidity.datatypes.DynamicArray;
import com.alaya.abi.solidity.datatypes.DynamicBytes;
import com.alaya.abi.solidity.datatypes.Fixed;
import com.alaya.abi.solidity.datatypes.Int;
import com.alaya.abi.solidity.datatypes.StaticArray;
import com.alaya.abi.solidity.datatypes.Type;
import com.alaya.abi.solidity.datatypes.Ufixed;
import com.alaya.abi.solidity.datatypes.Uint;
import com.alaya.abi.solidity.datatypes.Utf8String;
import com.alaya.abi.solidity.datatypes.generated.Int64;
import com.alaya.abi.solidity.datatypes.generated.StaticArray2;
import com.alaya.abi.solidity.datatypes.generated.Uint256;
import com.alaya.abi.solidity.datatypes.generated.Uint64;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testGetTypeName() throws ClassNotFoundException {
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Uint>(){}), (Matcher)CoreMatchers.is((Object)"uint256"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Int>(){}), (Matcher)CoreMatchers.is((Object)"int256"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Ufixed>(){}), (Matcher)CoreMatchers.is((Object)"ufixed256"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Fixed>(){}), (Matcher)CoreMatchers.is((Object)"fixed256"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Uint64>(){}), (Matcher)CoreMatchers.is((Object)"uint64"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Int64>(){}), (Matcher)CoreMatchers.is((Object)"int64"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Bool>(){}), (Matcher)CoreMatchers.is((Object)"bool"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<Utf8String>(){}), (Matcher)CoreMatchers.is((Object)"string"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<DynamicBytes>(){}), (Matcher)CoreMatchers.is((Object)"bytes"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference.StaticArrayTypeReference<StaticArray<Uint>>(5){}), (Matcher)CoreMatchers.is((Object)"uint256[5]"));
        MatcherAssert.assertThat((Object)Utils.getTypeName((TypeReference)new TypeReference<DynamicArray<Uint>>(){}), (Matcher)CoreMatchers.is((Object)"uint256[]"));
    }

    @Test
    public void testTypeMap() throws Exception {
        List<BigInteger> input = Arrays.asList(BigInteger.ZERO, BigInteger.ONE, BigInteger.TEN);
        MatcherAssert.assertThat((Object)Utils.typeMap(input, Uint256.class), (Matcher)CoreMatchers.equalTo(Arrays.asList(new Uint256(BigInteger.ZERO), new Uint256(BigInteger.ONE), new Uint256(BigInteger.TEN))));
    }

    @Test
    public void testTypeMapNested() {
        List<BigInteger> innerList1 = Arrays.asList(BigInteger.valueOf(1L), BigInteger.valueOf(2L));
        List<BigInteger> innerList2 = Arrays.asList(BigInteger.valueOf(3L), BigInteger.valueOf(4L));
        List<List> input = Arrays.asList(innerList1, innerList2);
        StaticArray2 staticArray1 = new StaticArray2((Type[])new Uint256[]{new Uint256(1L), new Uint256(2L)});
        StaticArray2 staticArray2 = new StaticArray2((Type[])new Uint256[]{new Uint256(3L), new Uint256(4L)});
        List<StaticArray2> expectedList = Arrays.asList(staticArray1, staticArray2);
        MatcherAssert.assertThat((Object)Utils.typeMap(input, StaticArray2.class, Uint256.class), (Matcher)CoreMatchers.equalTo(expectedList));
    }

    @Test
    public void testTypeMapEmpty() {
        MatcherAssert.assertThat((Object)Utils.typeMap(new ArrayList(), Uint256.class), (Matcher)CoreMatchers.equalTo(new ArrayList()));
    }
}

