/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.solidity.datatypes;

import com.alaya.abi.solidity.datatypes.Type;
import com.alaya.abi.solidity.datatypes.Uint;
import com.alaya.abi.solidity.datatypes.generated.StaticArray3;
import com.alaya.abi.solidity.datatypes.generated.StaticArray32;
import com.alaya.abi.solidity.datatypes.generated.Uint8;
import java.util.stream.IntStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class StaticArrayTest {
    @Test
    public void canBeInstantiatedWithLessThan32Elements() {
        StaticArray32 array = new StaticArray32((Type[])this.arrayOfUints(32));
        MatcherAssert.assertThat((Object)array.getValue().size(), (Matcher)CoreMatchers.equalTo((Object)32));
    }

    @Test
    public void canBeInstantiatedWithSizeMatchingType() {
        StaticArray3 array = new StaticArray3((Type[])this.arrayOfUints(3));
        MatcherAssert.assertThat((Object)array.getValue().size(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void throwsIfSizeDoesntMatchType() {
        try {
            new StaticArray3((Type[])this.arrayOfUints(4));
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Expected array of type [StaticArray3] to have [3] elements."));
        }
    }

    @Test
    public void throwsIfSizeIsAboveMaxOf32() {
        try {
            new StaticArray32((Type[])this.arrayOfUints(33));
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Static arrays with a length greater than 32 are not supported."));
        }
    }

    private Uint[] arrayOfUints(int length) {
        return (Uint[])IntStream.rangeClosed(1, length).mapToObj(Uint8::new).toArray(Uint[]::new);
    }
}

