/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.solidity;

import com.alaya.abi.solidity.TypeReference;
import com.alaya.abi.solidity.Utils;
import com.alaya.abi.solidity.datatypes.Address;
import com.alaya.abi.solidity.datatypes.Array;
import com.alaya.abi.solidity.datatypes.Bool;
import com.alaya.abi.solidity.datatypes.Bytes;
import com.alaya.abi.solidity.datatypes.DynamicArray;
import com.alaya.abi.solidity.datatypes.DynamicBytes;
import com.alaya.abi.solidity.datatypes.Fixed;
import com.alaya.abi.solidity.datatypes.FixedPointType;
import com.alaya.abi.solidity.datatypes.Int;
import com.alaya.abi.solidity.datatypes.IntType;
import com.alaya.abi.solidity.datatypes.NumericType;
import com.alaya.abi.solidity.datatypes.StaticArray;
import com.alaya.abi.solidity.datatypes.Type;
import com.alaya.abi.solidity.datatypes.Ufixed;
import com.alaya.abi.solidity.datatypes.Uint;
import com.alaya.abi.solidity.datatypes.Utf8String;
import com.alaya.abi.solidity.datatypes.generated.Uint160;
import com.alaya.utils.Numeric;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class TypeDecoder {
    static final int MAX_BYTE_LENGTH_FOR_HEX_STRING = 64;

    static <T extends Type> int getSingleElementLength(String input, int offset, Class<T> type, long chainId) {
        if (input.length() == offset) {
            return 0;
        }
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeUintAsInt(input, offset, chainId) / 32 + 2;
        }
        return 1;
    }

    static <T extends Type> T decode(String input, int offset, Class<T> type, long chainId) {
        if (NumericType.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeNumeric(input.substring(offset), type);
        }
        if (Address.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeAddress(input.substring(offset), chainId);
        }
        if (Bool.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeBool(input, offset);
        }
        if (Bytes.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeBytes(input, offset, type);
        }
        if (DynamicBytes.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeDynamicBytes(input, offset, chainId);
        }
        if (Utf8String.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeUtf8String(input, offset, chainId);
        }
        if (Array.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("Array types must be wrapped in a TypeReference");
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + type.getClass());
    }

    public static <T extends Array> T decode(String input, int offset, TypeReference<T> typeReference, long chainId) {
        Class<?> cls = ((ParameterizedType)typeReference.getType()).getRawType().getClass();
        if (StaticArray.class.isAssignableFrom(cls)) {
            return (T)((Array)TypeDecoder.decodeStaticArray(input, offset, typeReference, 1, chainId));
        }
        if (DynamicArray.class.isAssignableFrom(cls)) {
            return (T)((Array)TypeDecoder.decodeDynamicArray(input, offset, typeReference, chainId));
        }
        throw new UnsupportedOperationException("Unsupported TypeReference: " + cls.getName() + ", only Array types can be passed as TypeReferences");
    }

    static <T extends Type> T decode(String input, Class<T> type, long chainId) {
        return TypeDecoder.decode(input, 0, type, chainId);
    }

    static Address decodeAddress(String input, long chainId) {
        return new Address(TypeDecoder.decodeNumeric(input, Uint160.class), chainId);
    }

    static <T extends NumericType> T decodeNumeric(String input, Class<T> type) {
        try {
            byte[] inputByteArray = Numeric.hexStringToByteArray((String)input);
            int typeLengthAsBytes = TypeDecoder.getTypeLengthInBytes(type);
            byte[] resultByteArray = new byte[typeLengthAsBytes + 1];
            if (Int.class.isAssignableFrom(type) || Fixed.class.isAssignableFrom(type)) {
                resultByteArray[0] = inputByteArray[0];
            }
            int valueOffset = 32 - typeLengthAsBytes;
            System.arraycopy(inputByteArray, valueOffset, resultByteArray, 1, typeLengthAsBytes);
            BigInteger numericValue = new BigInteger(resultByteArray);
            return (T)((NumericType)type.getConstructor(BigInteger.class).newInstance(numericValue));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static <T extends NumericType> int getTypeLengthInBytes(Class<T> type) {
        return TypeDecoder.getTypeLength(type) >> 3;
    }

    static <T extends NumericType> int getTypeLength(Class<T> type) {
        if (IntType.class.isAssignableFrom(type)) {
            String regex = "(" + Uint.class.getSimpleName() + "|" + Int.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                return Integer.parseInt(splitName[1]);
            }
        } else if (FixedPointType.class.isAssignableFrom(type)) {
            String regex = "(" + Ufixed.class.getSimpleName() + "|" + Fixed.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                String[] bitsCounts = splitName[1].split("x");
                return Integer.parseInt(bitsCounts[0]) + Integer.parseInt(bitsCounts[1]);
            }
        }
        return 256;
    }

    static int decodeUintAsInt(String rawInput, int offset, long chainId) {
        String input = rawInput.substring(offset, offset + 64);
        return TypeDecoder.decode(input, 0, Uint.class, chainId).getValue().intValue();
    }

    static Bool decodeBool(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        BigInteger numericValue = Numeric.toBigInt((String)input);
        boolean value = numericValue.equals(BigInteger.ONE);
        return new Bool(value);
    }

    static <T extends Bytes> T decodeBytes(String input, Class<T> type) {
        return TypeDecoder.decodeBytes(input, 0, type);
    }

    static <T extends Bytes> T decodeBytes(String input, int offset, Class<T> type) {
        try {
            String simpleName = type.getSimpleName();
            String[] splitName = simpleName.split(Bytes.class.getSimpleName());
            int length = Integer.parseInt(splitName[1]);
            int hexStringLength = length << 1;
            byte[] bytes = Numeric.hexStringToByteArray((String)input.substring(offset, offset + hexStringLength));
            return (T)((Bytes)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static DynamicBytes decodeDynamicBytes(String input, int offset, long chainId) {
        int encodedLength = TypeDecoder.decodeUintAsInt(input, offset, chainId);
        int hexStringEncodedLength = encodedLength << 1;
        int valueOffset = offset + 64;
        String data = input.substring(valueOffset, valueOffset + hexStringEncodedLength);
        byte[] bytes = Numeric.hexStringToByteArray((String)data);
        return new DynamicBytes(bytes);
    }

    static Utf8String decodeUtf8String(String input, int offset, long chainId) {
        DynamicBytes dynamicBytesResult = TypeDecoder.decodeDynamicBytes(input, offset, chainId);
        byte[] bytes = dynamicBytesResult.getValue();
        return new Utf8String(new String(bytes, StandardCharsets.UTF_8));
    }

    static <T extends Type> T decodeStaticArray(String input, int offset, TypeReference<T> typeReference, int length, long chainId) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStaticArray(typeReference, elements, length);
        };
        return (T)TypeDecoder.decodeArrayElements(input, offset, typeReference, length, function, chainId);
    }

    private static <T extends Type> T instantiateStaticArray(TypeReference<T> typeReference, List<T> elements, int length) {
        try {
            Class<?> arrayClass = Class.forName("com.alaya.abi.solidity.datatypes.generated.StaticArray" + length);
            return (T)((Type)arrayClass.getConstructor(List.class).newInstance(elements));
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static <T extends Type> T decodeDynamicArray(String input, int offset, TypeReference<T> typeReference, long chainId) {
        int length = TypeDecoder.decodeUintAsInt(input, offset, chainId);
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                return DynamicArray.empty(typeName);
            }
            return new DynamicArray(elements);
        };
        int valueOffset = offset + 64;
        return (T)TypeDecoder.decodeArrayElements(input, valueOffset, typeReference, length, function, chainId);
    }

    private static <T extends Type> T decodeArrayElements(String input, int offset, TypeReference<T> typeReference, int length, BiFunction<List<T>, String, T> consumer, long chainId) {
        try {
            Class cls = Utils.getParameterizedTypeFromArray(typeReference);
            if (Array.class.isAssignableFrom(cls)) {
                throw new UnsupportedOperationException("Arrays of arrays are not currently supported for external functions, seehttp://solidity.readthedocs.io/en/develop/types.html#members");
            }
            ArrayList elements = new ArrayList(length);
            int i = 0;
            int currOffset = offset;
            while (i < length) {
                Object value = TypeDecoder.decode(input, currOffset, cls, chainId);
                elements.add(value);
                ++i;
                currOffset += TypeDecoder.getSingleElementLength(input, currOffset, cls, chainId) * 64;
            }
            String typeName = Utils.getSimpleTypeName(cls);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + typeReference.getType().getTypeName(), e);
        }
    }
}

