/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.bech32;

import com.alaya.utils.Numeric;
import com.alaya.utils.Strings;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Locale;

public class Bech32 {
    private static final int ADDRESS_SIZE = 160;
    private static final int ADDRESS_LENGTH_IN_HEX = 40;
    private static final String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final byte[] CHARSET_REV = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15, -1, 10, 17, 21, 20, 26, 30, 7, 5, -1, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1, -1, 29, -1, 24, 13, 25, 9, 8, 23, -1, 18, 22, 31, 27, 19, -1, 1, 0, 3, 16, 11, 28, 12, 14, 6, 4, 2, -1, -1, -1, -1, -1};

    private static int polymod(byte[] values) {
        int c = 1;
        for (byte v_i : values) {
            int c0 = c >>> 25 & 0xFF;
            c = (c & 0x1FFFFFF) << 5 ^ v_i & 0xFF;
            if ((c0 & 1) != 0) {
                c ^= 0x3B6A57B2;
            }
            if ((c0 & 2) != 0) {
                c ^= 0x26508E6D;
            }
            if ((c0 & 4) != 0) {
                c ^= 0x1EA119FA;
            }
            if ((c0 & 8) != 0) {
                c ^= 0x3D4233DD;
            }
            if ((c0 & 0x10) == 0) continue;
            c ^= 0x2A1462B3;
        }
        return c;
    }

    private static byte[] expandHrp(String hrp) {
        int hrpLength = hrp.length();
        byte[] ret = new byte[hrpLength * 2 + 1];
        for (int i = 0; i < hrpLength; ++i) {
            int c = hrp.charAt(i) & 0x7F;
            ret[i] = (byte)(c >>> 5 & 7);
            ret[i + hrpLength + 1] = (byte)(c & 0x1F);
        }
        ret[hrpLength] = 0;
        return ret;
    }

    private static boolean verifyChecksum(String hrp, byte[] values) {
        byte[] hrpExpanded = Bech32.expandHrp(hrp);
        byte[] combined = new byte[hrpExpanded.length + values.length];
        System.arraycopy(hrpExpanded, 0, combined, 0, hrpExpanded.length);
        System.arraycopy(values, 0, combined, hrpExpanded.length, values.length);
        return Bech32.polymod(combined) == 1;
    }

    private static byte[] createChecksum(String hrp, byte[] values) {
        byte[] hrpExpanded = Bech32.expandHrp(hrp);
        byte[] enc = new byte[hrpExpanded.length + values.length + 6];
        System.arraycopy(hrpExpanded, 0, enc, 0, hrpExpanded.length);
        System.arraycopy(values, 0, enc, hrpExpanded.length, values.length);
        int mod = Bech32.polymod(enc) ^ 1;
        byte[] ret = new byte[6];
        for (int i = 0; i < 6; ++i) {
            ret[i] = (byte)(mod >>> 5 * (5 - i) & 0x1F);
        }
        return ret;
    }

    public static String addressEncode(String hrp, String address) {
        return Bech32.encode(hrp, Bech32.convertBits(Numeric.hexStringToByteArray(address), 8, 5, true));
    }

    private static String encode(String hrp, byte[] values) {
        Bech32.checkArgument(hrp.length() >= 1, "Human-readable part is too short");
        Bech32.checkArgument(hrp.length() <= 83, "Human-readable part is too long");
        hrp = hrp.toLowerCase(Locale.ROOT);
        byte[] checksum = Bech32.createChecksum(hrp, values);
        byte[] combined = new byte[values.length + checksum.length];
        System.arraycopy(values, 0, combined, 0, values.length);
        System.arraycopy(checksum, 0, combined, values.length, checksum.length);
        StringBuilder sb = new StringBuilder(hrp.length() + 1 + combined.length);
        sb.append(hrp);
        sb.append('1');
        for (byte b : combined) {
            sb.append(CHARSET.charAt(b));
        }
        return sb.toString();
    }

    private static Bech32Data decode(String str) throws RuntimeException {
        boolean lower = false;
        boolean upper = false;
        int pos = str.lastIndexOf(49);
        int dataPartLength = str.length() - 1 - pos;
        byte[] values = new byte[dataPartLength];
        for (int i = 0; i < dataPartLength; ++i) {
            char c = str.charAt(i + pos + 1);
            values[i] = CHARSET_REV[c];
        }
        String hrp = str.substring(0, pos).toLowerCase(Locale.ROOT);
        if (!Bech32.verifyChecksum(hrp, values)) {
            throw new RuntimeException();
        }
        return new Bech32Data(hrp, Arrays.copyOfRange(values, 0, values.length - 6));
    }

    public static byte[] addressDecode(String str) throws RuntimeException {
        if (Strings.isBlank(str)) {
            return new byte[0];
        }
        Bech32Data bech32Data = Bech32.decode(str);
        return Bech32.convertBits(bech32Data.data, 5, 8, false);
    }

    public static String addressDecodeHex(String str) throws RuntimeException {
        byte[] bytes = Bech32.addressDecode(str);
        return Numeric.toHexStringWithPrefixZeroPadded(Numeric.toBigInt(bytes), 40);
    }

    private static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    private static byte[] convertBits(byte[] in, int fromBits, int toBits, boolean pad) {
        int acc = 0;
        int bits = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(64);
        int maxv = (1 << toBits) - 1;
        int max_acc = (1 << fromBits + toBits - 1) - 1;
        for (int i = 0; i < in.length; ++i) {
            int value = in[i] & 0xFF;
            if (value >>> fromBits != 0) {
                throw new RuntimeException(String.format("Input value '%X' exceeds '%d' bit size", value, fromBits));
            }
            acc = (acc << fromBits | value) & max_acc;
            bits += fromBits;
            while (bits >= toBits) {
                out.write(acc >>> (bits -= toBits) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                out.write(acc << toBits - bits & maxv);
            }
        } else if (bits >= fromBits || (acc << toBits - bits & maxv) != 0) {
            throw new RuntimeException("Could not convert bits, invalid padding");
        }
        return out.toByteArray();
    }

    private static class Bech32Data {
        public final String hrp;
        public final byte[] data;

        private Bech32Data(String hrp, byte[] data) {
            this.hrp = hrp;
            this.data = data;
        }
    }
}

