/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.wasm;

import com.alaya.rlp.wasm.datatypes.Int;
import com.alaya.rlp.wasm.datatypes.Int8;
import com.alaya.rlp.wasm.datatypes.Uint;
import com.alaya.rlp.wasm.datatypes.Uint8;
import com.alaya.rlp.wasm.datatypes.WasmAddress;
import com.alaya.utils.Numeric;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class WasmEventDecoder {
    private WasmEventDecoder() {
    }

    public static byte[] decodeIndexParameterByteArray(String topic) {
        byte[] bytes = Numeric.hexStringToByteArray((String)topic);
        int index = 0;
        for (index = 0; index < bytes.length && bytes[index] == 0; ++index) {
        }
        byte[] newBytes = new byte[bytes.length - index];
        System.arraycopy(bytes, index, newBytes, 0, newBytes.length);
        return newBytes;
    }

    public static <T> List<T> decodeIndexParameterList(String topic, Class<T> type) {
        try {
            if (Int8.class.isAssignableFrom(type)) {
                return WasmEventDecoder.decodeInt8List(topic);
            }
            if (Uint8.class.isAssignableFrom(type)) {
                return WasmEventDecoder.decodeUint8List(topic);
            }
            throw new UnsupportedOperationException("Topic cannot be decode: " + type.getClass());
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("decode error ", e);
        }
    }

    private static List<Uint8> decodeUint8List(String topic) {
        ArrayList<Uint8> result = new ArrayList<Uint8>();
        byte[] bytes = Numeric.hexStringToByteArray((String)topic);
        int index = 0;
        for (index = 0; index < bytes.length && bytes[index] == 0; ++index) {
        }
        byte[] newBytes = new byte[bytes.length - index];
        System.arraycopy(bytes, index, newBytes, 0, newBytes.length);
        for (int i = 0; i < newBytes.length; ++i) {
            result.add(Uint8.of((BigInteger)new BigInteger(1, new byte[]{newBytes[i]})));
        }
        return result;
    }

    private static List<Int8> decodeInt8List(String topic) {
        ArrayList<Int8> result = new ArrayList<Int8>();
        byte[] bytes = Numeric.hexStringToByteArray((String)topic);
        int index = 0;
        for (index = 0; index < bytes.length && bytes[index] == 0; ++index) {
        }
        byte[] newBytes = new byte[bytes.length - index];
        System.arraycopy(bytes, index, newBytes, 0, newBytes.length);
        for (int i = 0; i < newBytes.length; ++i) {
            result.add(Int8.of((BigInteger)new BigInteger(new byte[]{newBytes[i]})));
        }
        return result;
    }

    public static <T> T decodeIndexParameter(String topic, Class<T> type) {
        try {
            if (Int.class.isAssignableFrom(type)) {
                return WasmEventDecoder.decodeInt(topic, type);
            }
            if (Uint.class.isAssignableFrom(type)) {
                return WasmEventDecoder.decodeUint(topic, type);
            }
            if (Boolean.class.isAssignableFrom(type)) {
                return (T)WasmEventDecoder.decodeBoolean(topic);
            }
            if (String.class.isAssignableFrom(type)) {
                return (T)WasmEventDecoder.decodeString(topic);
            }
            if (WasmAddress.class.isAssignableFrom(type)) {
                return (T)WasmEventDecoder.decodeAddress(topic);
            }
            throw new UnsupportedOperationException("Topic cannot be decode: " + type.getClass());
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("decode error ", e);
        }
    }

    private static WasmAddress decodeAddress(String topic) {
        return new WasmAddress(Numeric.toBigInt((String)topic));
    }

    private static String decodeString(String topic) {
        byte[] bytes = Numeric.hexStringToByteArray((String)topic);
        int index = 0;
        for (index = 0; index < bytes.length && bytes[index] == 0; ++index) {
        }
        byte[] newBytes = new byte[bytes.length - index];
        System.arraycopy(bytes, index, newBytes, 0, newBytes.length);
        return new String(newBytes, StandardCharsets.UTF_8);
    }

    private static Boolean decodeBoolean(String topic) {
        BigInteger bigInteger = Numeric.toBigInt((String)topic);
        if (bigInteger.signum() == 0) {
            return Boolean.FALSE;
        }
        if (bigInteger.compareTo(BigInteger.ONE) == 0) {
            return Boolean.TRUE;
        }
        throw new UnsupportedOperationException("decode boolean error value = " + bigInteger);
    }

    private static <T extends Uint> T decodeUint(String topic, Class<Uint> type) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        BigInteger bigInteger = Numeric.toBigInt((String)topic);
        Method method = type.getMethod("of", BigInteger.class);
        return (T)((Uint)method.invoke(null, bigInteger));
    }

    private static <T extends Int> T decodeInt(String topic, Class<Int> type) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        BigInteger bigInteger = Numeric.toBigInt((String)topic);
        Method method = type.getMethod("ofUnsignedValue", BigInteger.class);
        return (T)((Int)method.invoke(null, bigInteger));
    }
}

