/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.domain.account;

import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.domain.account.Signer;
import com.alipay.chainstack.jbcc.mychainx.domain.blockchain.IBaseChainClient;
import com.alipay.chainstack.jbcc.mychainx.exception.error.ErrorCode;
import com.alipay.chainstack.jbcc.mychainx.model.account.AccountModel;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.chainstack.jbcc.mychainx.model.account.NamedIdentity;
import com.alipay.chainstack.jbcc.mychainx.model.request.AccountCreateRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.AccountFreezeRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.AccountUnfreezeRequestModel;
import com.alipay.chainstack.jbcc.mychainx.util.IdentityUtils;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import java.util.Map;

public class Account {
    private Identity id;
    private String name;
    private AccountModel accountModel;
    private Signer signer;
    private IBaseChainClient client;
    private String subnetId = null;

    public Account() {
    }

    public Account(String name, Signer signer, IBaseChainClient client) {
        this.name = name;
        this.id = new NamedIdentity(name);
        this.signer = signer;
        this.client = client;
    }

    public String getName() {
        return this.name;
    }

    public Account setName(String name) {
        this.name = name;
        if (!StringUtils.isEmpty((String)name)) {
            this.id = new NamedIdentity(name);
        }
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Account setSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public Identity getId() {
        return this.id;
    }

    public Account setId(Identity id) {
        this.id = id;
        if (id instanceof NamedIdentity) {
            this.name = ((NamedIdentity)id).getName();
        }
        return this;
    }

    public IBaseChainClient getClient() {
        return this.client;
    }

    public Account setClient(IBaseChainClient client) {
        this.client = client;
        return this;
    }

    public NamedIdentity create(String name, Map<Keypair, Integer> authKeys, Keypair recoverKey, byte[] encryptionKey) {
        AccountCreateRequestModel request = (AccountCreateRequestModel)new AccountCreateRequestModel().setAuthKeys(authKeys).setRecoverKey(recoverKey).setEncryptionKey(encryptionKey).setAccountName(name).setSigner(this.signer).setSubnetId(this.subnetId).setFrom(this.id);
        return this.client.createAccount(request);
    }

    public boolean freeze(String accountName) {
        return this.freeze(IdentityUtils.getIdentityByName(accountName));
    }

    public boolean freeze(Account account) {
        return this.freeze(account.getId());
    }

    public boolean freeze(Identity id) {
        AccountFreezeRequestModel request = (AccountFreezeRequestModel)new AccountFreezeRequestModel(this.id, id).setSigner(this.signer).setSubnetId(this.subnetId);
        return this.client.freezeAccount(request).getResult() == (long)ErrorCode.SUCCESS.getErrorCode();
    }

    public boolean unfreeze(String accountName) {
        return this.unfreeze(IdentityUtils.getIdentityByName(accountName));
    }

    public boolean unfreeze(Account account) {
        return this.unfreeze(account.getId());
    }

    public boolean unfreeze(Identity id) {
        AccountUnfreezeRequestModel request = (AccountUnfreezeRequestModel)new AccountUnfreezeRequestModel(this.id, id).setSigner(this.signer).setSubnetId(this.subnetId);
        return this.client.unfreezeAccount(request).getResult() == (long)ErrorCode.SUCCESS.getErrorCode();
    }

    public Signer getSigner() {
        return this.signer;
    }

    public Account setSigner(Signer signer) {
        this.signer = signer;
        return this;
    }

    public AccountModel getAccountModel() {
        return this.accountModel;
    }

    public Account setAccountModel(AccountModel accountModel) {
        this.accountModel = accountModel;
        return this;
    }

    public boolean isEscrowAccount() {
        return this.signer == null;
    }
}

