/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.domain.account;

import com.alipay.chainstack.jbcc.mychainx.domain.account.Account;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.util.IdentityUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AccountManager {
    private final Map<Identity, Account> accountMap = new ConcurrentHashMap<Identity, Account>();
    private static final AccountManager INSTANCE = new AccountManager();

    private AccountManager() {
    }

    public static AccountManager getInstance() {
        return INSTANCE;
    }

    public void setAccounts(List<Account> accounts) {
        for (Account account : accounts) {
            this.accountMap.put(account.getId(), account);
        }
    }

    public boolean hasAccount(String accountName) {
        return this.accountMap.containsKey((Object)IdentityUtils.getIdentityByName(accountName));
    }

    public boolean hasAccount(Identity accountId) {
        return this.accountMap.containsKey((Object)accountId);
    }

    public void addAccount(Account account) {
        this.accountMap.put(account.getId(), account);
    }

    public Account getAccountByName(String accountName) {
        return this.getAccountByIdentity(IdentityUtils.getIdentityByName(accountName));
    }

    public Account getAccountByNameHex(String accountNameHex) {
        return this.getAccountByIdentity(new Identity(accountNameHex));
    }

    public Account getAccountByIdentity(Identity identity) {
        return this.accountMap.get((Object)identity);
    }

    public static List<byte[]> sign(Identity signer, TransactionModel tx) {
        return AccountManager.sign(signer, tx.getHash().getData());
    }

    public static List<byte[]> sign(Identity signer, byte[] data) {
        if (signer == null) {
            throw new RuntimeException("msg signer is not set");
        }
        if (data == null) {
            throw new RuntimeException("sign data is empty");
        }
        Account account = INSTANCE.getAccountByIdentity(signer);
        if (account == null) {
            throw new RuntimeException(String.format("account is %s not found in account manager", signer.hexStrValue()));
        }
        if (account.isEscrowAccount()) {
            throw new RuntimeException(String.format("account %s is an escrow account, cannot do local sign", account.getName()));
        }
        return account.getSigner().sign(data);
    }
}

