/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.domain.bao;

import com.alipay.chainstack.jbcc.mychainx.domain.contract.Contract;
import com.alipay.chainstack.jbcc.mychainx.model.receipt.ReceiptModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.BaseBAORequest;
import com.alipay.chainstack.jbcc.mychainx.model.request.RequestContext;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionType;

public abstract class BaseBAO {
    protected Contract contract;

    public BaseBAO() {
    }

    public BaseBAO(Contract contract) {
        this.contract = contract;
    }

    public void checkRequestIntegrity(BaseBAORequest baoRequest) {
        RequestContext context = baoRequest.getReqContext();
        if (context.getTransaction() != null) {
            this.checkTransactionIntegrity(context.getTransaction());
            return;
        }
        if (!context.getContract().getId().equals((Object)this.contract.getId())) {
            throw new RuntimeException("contract id does not match with the request");
        }
        if (context.getAccount() == null) {
            throw new RuntimeException("account is not set for the request");
        }
    }

    protected void checkTransactionIntegrity(TransactionModel tx) {
        if (tx.getTxType().equals((Object)TransactionType.TX_CALL_CONTRACT) && !tx.getTo().equals((Object)this.contract.getId())) {
            throw new RuntimeException("transaction contract does not match bao contract address");
        }
        if (!tx.getTxType().equals((Object)TransactionType.TX_CALL_CONTRACT) && !tx.getTxType().equals((Object)TransactionType.TX_CONFIDENTIAL)) {
            throw new RuntimeException("request mode does not match with tx");
        }
        if (tx.getHash() == null) {
            throw new RuntimeException("transaction is not completed");
        }
    }

    protected ReceiptModel processTransaction(BaseBAORequest request) {
        request.getReqContext().setContract(this.getContract());
        this.checkRequestIntegrity(request);
        ReceiptModel receipt = request.getReqContext().getTransaction() != null ? (request.getReqContext().isLocalCall() ? this.contract.localCall(request.getReqContext().getTransaction(), request.getReqContext().getBlockNumber()) : this.contract.call(request.getReqContext().getTransaction())) : this.contract.processCall(request);
        request.getReqContext().setTxHash(receipt.getTxHash());
        request.getReqContext().setTxIndex(receipt.getTxIndex());
        return receipt;
    }

    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }
}

