/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.domain.contract;

import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.domain.account.Signer;
import com.alipay.chainstack.jbcc.mychainx.domain.blockchain.IBaseChainClient;
import com.alipay.chainstack.jbcc.mychainx.domain.contract.Contract;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.chainstack.jbcc.mychainx.model.receipt.ReceiptModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.BaseBAORequest;
import com.alipay.chainstack.jbcc.mychainx.model.request.ConfidentialRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractCallRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractDeployRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractUpdateRequestModel;
import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import java.math.BigInteger;

public class ConfidentialContract
extends Contract {
    protected String encryptionKey;

    public ConfidentialContract() {
    }

    public ConfidentialContract(String name, IBaseChainClient client, String encryptionKey) {
        this(name, VMTypeEnum.WASM, client, encryptionKey);
    }

    public ConfidentialContract(String name, VMTypeEnum vmType, IBaseChainClient client, String encryptionKey) {
        super(name, vmType, client);
        this.encryptionKey = encryptionKey;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public ConfidentialContract setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    @Override
    public ReceiptModel deploy(Parameters parameters, BigInteger value, BigInteger gas, Signer signer) {
        if (StringUtils.isEmpty((String)this.encryptionKey)) {
            throw new RuntimeException(String.format("encryption key of contract %s is not set", this.id.hexStrValue()));
        }
        ContractDeployRequestModel request = (ContractDeployRequestModel)new ContractDeployRequestModel().setCode(this.code).setParameters(parameters).setVmType(this.vmType).setFrom(this.admin).setGas(gas).setSigner(signer).setValue(value).setTo(this.id);
        ConfidentialRequestModel confidentialRequestModel = new ConfidentialRequestModel(request, this.encryptionKey);
        return this.getClient().confidentialRequest(confidentialRequestModel);
    }

    @Override
    public ReceiptModel update(BigInteger value, BigInteger gas, Signer signer) {
        if (StringUtils.isEmpty((String)this.encryptionKey)) {
            throw new RuntimeException(String.format("encryption key of contract %s is not set", this.id.hexStrValue()));
        }
        ContractUpdateRequestModel request = (ContractUpdateRequestModel)new ContractUpdateRequestModel().setVmType(this.vmType).setCode(this.code).setFrom(this.admin).setGas(gas).setValue(value).setSigner(signer).setTo(this.id);
        ConfidentialRequestModel confidentialRequestModel = new ConfidentialRequestModel(request, this.encryptionKey);
        return this.getClient().confidentialRequest(confidentialRequestModel);
    }

    @Override
    public ReceiptModel call(Identity from, Parameters parameters, BigInteger value, BigInteger gas, Signer signer) {
        return this.processCall(from, parameters, BigInteger.ZERO, value, gas, false, signer);
    }

    @Override
    public ReceiptModel localCall(Identity from, Parameters parameters, BigInteger value, BigInteger blockNumber, BigInteger gas, Signer signer) {
        return this.processCall(from, parameters, blockNumber, value, gas, true, signer);
    }

    @Override
    protected ReceiptModel processCall(Identity from, Parameters parameters, BigInteger blockNumber, BigInteger value, BigInteger gas, boolean isLocal, Signer signer) {
        if (StringUtils.isEmpty((String)this.encryptionKey)) {
            throw new RuntimeException(String.format("encryption key of contract %s is not set", this.id.hexStrValue()));
        }
        ContractCallRequestModel request = (ContractCallRequestModel)new ContractCallRequestModel().setParameters(parameters).setVmType(this.vmType).setValue(value).setFrom(from).setTo(this.id).setSigner(signer).setLocalCall(isLocal).setBlockNumber(blockNumber).setGas(gas);
        ConfidentialRequestModel confidentialRequest = new ConfidentialRequestModel(request, this.encryptionKey);
        return this.getClient().confidentialRequest(confidentialRequest);
    }

    @Override
    public ReceiptModel processCall(BaseBAORequest baoRequest) {
        if (StringUtils.isEmpty((String)this.encryptionKey)) {
            throw new RuntimeException(String.format("encryption key of contract %s is not set", this.id.hexStrValue()));
        }
        ContractCallRequestModel request = (ContractCallRequestModel)new ContractCallRequestModel().setParameters(baoRequest.getParameters()).setVmType(this.vmType).setValue(baoRequest.getReqContext().getValue()).setFrom(baoRequest.getReqContext().getAccount()).setTo(this.id).setSigner(baoRequest.getReqContext().getSigner()).setLocalCall(baoRequest.getReqContext().isLocalCall()).setBlockNumber(baoRequest.getReqContext().getBlockNumber()).setTransactionModel(baoRequest.getReqContext().getTransaction()).setGas(baoRequest.getReqContext().getGas());
        ConfidentialRequestModel confidentialRequest = new ConfidentialRequestModel(request, this.encryptionKey);
        return this.getClient().confidentialRequest(confidentialRequest);
    }
}

