/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.domain.contract;

import com.alipay.chainstack.commons.utils.ResourceUtils;
import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.domain.account.Account;
import com.alipay.chainstack.jbcc.mychainx.domain.account.Signer;
import com.alipay.chainstack.jbcc.mychainx.domain.blockchain.IBaseChainClient;
import com.alipay.chainstack.jbcc.mychainx.exception.RichClientException;
import com.alipay.chainstack.jbcc.mychainx.exception.error.ErrorCode;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.chainstack.jbcc.mychainx.model.account.NamedIdentity;
import com.alipay.chainstack.jbcc.mychainx.model.receipt.ReceiptModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.BaseBAORequest;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractCallRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractDeployRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractUpdateRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import java.math.BigInteger;

public class Contract {
    protected Identity id;
    protected Identity admin;
    protected String name;
    protected byte[] code;
    protected VMTypeEnum vmType;
    protected IBaseChainClient client;
    protected String subnetId = null;
    protected String codePath;

    public Contract() {
    }

    public Contract(String name, IBaseChainClient client) {
        this(name, VMTypeEnum.WASM, client);
    }

    public Contract(Identity id, IBaseChainClient client) {
        this(id, VMTypeEnum.WASM, client);
    }

    public Contract(Identity id, VMTypeEnum vmType, IBaseChainClient client) {
        this.id = id;
        this.vmType = vmType;
        this.client = client;
    }

    public Contract(String name, VMTypeEnum vmType, IBaseChainClient client) {
        this.id = new NamedIdentity(name);
        this.name = name;
        this.client = client;
        this.vmType = vmType;
    }

    public String getName() {
        return this.name;
    }

    public Contract setName(String name) {
        this.name = name;
        if (!StringUtils.isEmpty((String)name)) {
            this.id = new NamedIdentity(name);
        }
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Contract setSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public Identity getId() {
        return this.id;
    }

    public Contract setId(Identity id) {
        this.id = id;
        if (id instanceof NamedIdentity) {
            this.name = ((NamedIdentity)id).getName();
        }
        return this;
    }

    public Contract setAdmin(Identity adminId) {
        this.admin = adminId;
        return this;
    }

    public Contract setAdmin(Account account) {
        if (null != account) {
            this.admin = account.getId();
        }
        return this;
    }

    public Identity getAdmin() {
        return this.admin;
    }

    public Contract setCode(byte[] code) {
        this.code = code;
        return this;
    }

    public byte[] getCode() {
        return this.code;
    }

    public Contract setCodePath(String codePath) {
        this.codePath = codePath;
        if (!StringUtils.isEmpty((String)codePath)) {
            this.code = ResourceUtils.readResourceBytes((String)codePath);
        }
        return this;
    }

    public String getCodePath() {
        return this.codePath;
    }

    public VMTypeEnum getVmType() {
        return this.vmType;
    }

    public Contract setVmType(VMTypeEnum vmType) {
        this.vmType = vmType;
        return this;
    }

    public Contract setClient(IBaseChainClient client) {
        this.client = client;
        return this;
    }

    public String getAdminName() {
        if (this.admin instanceof NamedIdentity) {
            return ((NamedIdentity)this.admin).getName();
        }
        return null;
    }

    public Contract setAdminName(String adminName) {
        if (!StringUtils.isEmpty((String)adminName)) {
            this.admin = new NamedIdentity(adminName);
        }
        return this;
    }

    public ReceiptModel deploy() {
        return this.deploy(null, BigInteger.ZERO);
    }

    public ReceiptModel deploy(Parameters parameters, BigInteger value) {
        return this.deploy(parameters, value, BigInteger.ZERO);
    }

    public ReceiptModel deploy(Parameters parameters, BigInteger value, BigInteger gas) {
        return this.deploy(parameters, value, gas, null);
    }

    public ReceiptModel deploy(Parameters parameters, BigInteger value, BigInteger gas, Signer signer) {
        ContractDeployRequestModel request = (ContractDeployRequestModel)new ContractDeployRequestModel().setCode(this.code).setParameters(parameters).setVmType(this.vmType).setFrom(this.admin).setGas(gas).setValue(value).setSigner(signer).setSubnetId(this.subnetId).setTo(this.id);
        return this.getClient().deployContract(request);
    }

    public ReceiptModel update() {
        return this.update(BigInteger.ZERO, BigInteger.ZERO);
    }

    public ReceiptModel update(BigInteger value) {
        return this.update(value, BigInteger.ZERO);
    }

    public ReceiptModel update(BigInteger value, BigInteger gas) {
        return this.update(value, gas, null);
    }

    public ReceiptModel update(BigInteger value, BigInteger gas, Signer signer) {
        ContractUpdateRequestModel request = (ContractUpdateRequestModel)new ContractUpdateRequestModel().setVmType(this.vmType).setCode(this.code).setFrom(this.admin).setGas(gas).setValue(value).setSigner(signer).setSubnetId(this.subnetId).setTo(this.id);
        return this.getClient().updateContract(request);
    }

    public ReceiptModel call(TransactionModel transactionModel) {
        return this.getClient().sendTransaction(transactionModel).getReceiptModel();
    }

    public ReceiptModel call(Parameters parameters) {
        if (this.admin == null) {
            throw new RuntimeException(String.format("no default account set for contract %s", this.name));
        }
        return this.call(this.admin, parameters);
    }

    public ReceiptModel call(Identity from, Parameters parameters) {
        return this.call(from, parameters, BigInteger.ZERO);
    }

    public ReceiptModel call(Identity from, Parameters parameters, BigInteger value) {
        return this.call(from, parameters, value, BigInteger.ZERO);
    }

    public ReceiptModel call(Identity from, Parameters parameters, BigInteger value, BigInteger gas) {
        return this.processCall(from, parameters, null, value, gas, false, null);
    }

    public ReceiptModel call(Identity from, Parameters parameters, BigInteger value, BigInteger gas, Signer signer) {
        return this.processCall(from, parameters, null, value, gas, false, signer);
    }

    public ReceiptModel localCall(TransactionModel transactionModel) {
        return this.localCall(transactionModel, null);
    }

    public ReceiptModel localCall(TransactionModel transactionModel, BigInteger blockNumber) {
        return this.getClient().sendLocalTransaction(transactionModel, blockNumber).getReceiptModel();
    }

    public ReceiptModel localCall(Parameters parameters) {
        return this.localCall(parameters, BigInteger.ZERO);
    }

    public ReceiptModel localCall(Parameters parameters, BigInteger value) {
        if (this.admin == null) {
            throw new RuntimeException(String.format("no default account set for contract %s", this.name));
        }
        return this.localCall(this.admin, parameters, value);
    }

    public ReceiptModel localCall(Identity from, Parameters parameters, BigInteger value) {
        return this.localCall(from, parameters, value, null);
    }

    public ReceiptModel localCall(Identity from, Parameters parameters, BigInteger value, BigInteger blockNumber) {
        return this.localCall(from, parameters, value, blockNumber, BigInteger.ZERO);
    }

    public ReceiptModel localCall(Identity from, Parameters parameters, BigInteger value, BigInteger blockNumber, BigInteger gas) {
        return this.processCall(from, parameters, blockNumber, value, gas, true, null);
    }

    public ReceiptModel localCall(Identity from, Parameters parameters, BigInteger value, BigInteger blockNumber, BigInteger gas, Signer signer) {
        return this.processCall(from, parameters, blockNumber, value, gas, true, signer);
    }

    protected ReceiptModel processCall(Identity from, Parameters parameters, BigInteger blockNumber, BigInteger value, BigInteger gas, boolean isLocal, Signer signer) {
        ContractCallRequestModel request = (ContractCallRequestModel)new ContractCallRequestModel().setParameters(parameters).setVmType(this.vmType).setValue(value).setFrom(from).setTo(this.id).setGas(gas).setSigner(signer).setSubnetId(this.subnetId).setLocalCall(isLocal).setBlockNumber(blockNumber);
        return this.getClient().callContract(request);
    }

    public ContractCallRequestModel buildRequest(BaseBAORequest baoRequest) {
        return (ContractCallRequestModel)new ContractCallRequestModel().setParameters(baoRequest.getParameters()).setVmType(this.vmType).setValue(baoRequest.getReqContext().getValue()).setFrom(baoRequest.getReqContext().getAccount()).setTo(this.id).setGas(baoRequest.getReqContext().getGas()).setSigner(baoRequest.getReqContext().getSigner()).setLocalCall(baoRequest.getReqContext().isLocalCall()).setBlockNumber(baoRequest.getReqContext().getBlockNumber()).setSubnetId(baoRequest.getReqContext().getSubnetId() == null ? this.subnetId : baoRequest.getReqContext().getSubnetId()).setTransactionModel(baoRequest.getReqContext().getTransaction());
    }

    public ReceiptModel processCall(BaseBAORequest baoRequest) {
        return this.getClient().callContract(this.buildRequest(baoRequest));
    }

    public IBaseChainClient getClient() {
        if (null == this.client) {
            throw new RichClientException(ErrorCode.CHAIN_CLIENT_NOT_SET, "chain client is not set in this contract");
        }
        return this.client;
    }
}

