/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.domain.contract;

import com.alipay.chainstack.jbcc.mychainx.domain.account.Signer;
import com.alipay.chainstack.jbcc.mychainx.domain.blockchain.IBaseChainClient;
import com.alipay.chainstack.jbcc.mychainx.domain.contract.Contract;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.chainstack.jbcc.mychainx.model.acl.ContractACL;
import com.alipay.chainstack.jbcc.mychainx.model.receipt.ReceiptModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.BaseBAORequest;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractCallRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.DataContractDeployRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.DataContractGetACLRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.DataContractSetACLRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.DataContractUpdateRequestModel;
import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class DataContract
extends Contract {
    public DataContract() {
        this.vmType = VMTypeEnum.DCVM;
    }

    public DataContract(String name, IBaseChainClient client) {
        super(name, client);
        this.vmType = VMTypeEnum.DCVM;
    }

    public DataContract(Identity id, IBaseChainClient client) {
        super(id, client);
        this.vmType = VMTypeEnum.DCVM;
    }

    @Override
    public Contract setVmType(VMTypeEnum vmType) {
        throw new RuntimeException("cannot set vm type for data contract");
    }

    @Override
    public ReceiptModel deploy() {
        return this.deploy(BigInteger.ZERO);
    }

    @Override
    public ReceiptModel deploy(Parameters parameters, BigInteger value) {
        return this.deploy(parameters, value, BigInteger.ZERO);
    }

    @Override
    public ReceiptModel deploy(Parameters parameters, BigInteger value, BigInteger gas) {
        return this.deploy(parameters, value, gas, null);
    }

    @Override
    public ReceiptModel deploy(Parameters parameters, BigInteger value, BigInteger gas, Signer signer) {
        throw new RuntimeException("data contract does not support deploy with parameter");
    }

    public ReceiptModel deploy(BigInteger value) {
        return this.deploy(value, BigInteger.ZERO);
    }

    public ReceiptModel deploy(BigInteger value, BigInteger gas) {
        return this.deploy(value, gas, null);
    }

    public ReceiptModel deploy(BigInteger value, BigInteger gas, Signer signer) {
        DataContractDeployRequestModel request = (DataContractDeployRequestModel)new DataContractDeployRequestModel().setCode(this.code).setFrom(this.admin).setGas(gas).setValue(value).setSigner(signer).setSubnetId(this.subnetId).setTo(this.id);
        return this.getClient().deployContract(request);
    }

    @Override
    public ReceiptModel update() {
        return this.update(BigInteger.ZERO);
    }

    @Override
    public ReceiptModel update(BigInteger value) {
        return this.update(value, BigInteger.ZERO);
    }

    @Override
    public ReceiptModel update(BigInteger value, BigInteger gas) {
        return this.update(value, gas, null);
    }

    @Override
    public ReceiptModel update(BigInteger value, BigInteger gas, Signer signer) {
        DataContractUpdateRequestModel request = (DataContractUpdateRequestModel)new DataContractUpdateRequestModel().setCode(this.code).setFrom(this.admin).setGas(gas).setValue(value).setSigner(signer).setSubnetId(this.subnetId).setTo(this.id);
        return this.getClient().updateContract(request);
    }

    public ReceiptModel setACL(ContractACL ... contractACL) {
        return this.setACL(contractACL == null ? new ArrayList<ContractACL>() : Lists.newArrayList((Object[])contractACL));
    }

    public ReceiptModel setACL(List<ContractACL> contractACL) {
        return this.setACL(null, contractACL);
    }

    public ReceiptModel setACL(Signer signer, ContractACL ... contractACL) {
        return this.setACL(signer, contractACL == null ? new ArrayList<ContractACL>() : Lists.newArrayList((Object[])contractACL));
    }

    public ReceiptModel setACL(Signer signer, List<ContractACL> contractACL) {
        DataContractSetACLRequestModel setRequest = (DataContractSetACLRequestModel)new DataContractSetACLRequestModel().setContractACLList(contractACL == null ? new ArrayList() : contractACL).setFrom(this.admin).setTo(this.id).setSigner(signer).setSubnetId(this.subnetId);
        return this.getClient().setContractACL(setRequest);
    }

    public List<ContractACL> getACL(Identity ... contract) {
        return this.getACL(contract == null ? new ArrayList<Identity>() : Lists.newArrayList((Object[])contract));
    }

    public List<ContractACL> getACL(List<Identity> contract) {
        return this.getACL(null, contract);
    }

    public List<ContractACL> getACL(Signer signer, Identity ... contract) {
        return this.getACL(signer, contract == null ? new ArrayList<Identity>() : Lists.newArrayList((Object[])contract));
    }

    public List<ContractACL> getACL(Signer signer, List<Identity> contract) {
        DataContractGetACLRequestModel getRequest = (DataContractGetACLRequestModel)new DataContractGetACLRequestModel().setContracts(contract == null ? new ArrayList() : contract).setFrom(this.admin).setTo(this.id).setSigner(signer).setSubnetId(this.subnetId);
        return this.getClient().getContractACL(getRequest).getContractACLs();
    }

    @Override
    public ContractCallRequestModel buildRequest(BaseBAORequest baoRequest) {
        throw new RuntimeException("data contract does not support call with bao request");
    }

    @Override
    public ReceiptModel processCall(BaseBAORequest baoRequest) {
        throw new RuntimeException("data contract does not support bao request processing");
    }
}

