/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.domain.key;

import com.alipay.chainstack.commons.utils.ByteUtils;
import com.alipay.chainstack.commons.utils.ResourceUtils;
import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.domain.key.Key;
import com.alipay.chainstack.jbcc.mychainx.exception.RichClientException;
import com.alipay.chainstack.jbcc.mychainx.exception.error.ErrorCode;
import com.alipay.mychain.sdk.crypto.keyoperator.Pkcs8KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;

public abstract class AbstractFileKey
implements Key {
    protected SignerBase signer;
    protected byte[] privateKey;
    protected String privateKeyPath;
    protected String privateKeyPassword;
    protected Keypair keyPair;

    public AbstractFileKey setSigner(SignerBase signer) {
        this.signer = signer;
        return this;
    }

    public AbstractFileKey setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public AbstractFileKey setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    public AbstractFileKey setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public AbstractFileKey setKeyPair(Keypair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    @Override
    public Keypair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public byte[] getPublicKey() {
        return this.keyPair.getPubkeyEncoded();
    }

    protected void initKeyPair() {
        boolean isPrivateKeyEmpty = ByteUtils.isEmpty((byte[])this.privateKey);
        boolean isPrivateKeyPathEmpty = StringUtils.isEmpty((String)this.privateKeyPath);
        if (isPrivateKeyEmpty && isPrivateKeyPathEmpty) {
            throw new RichClientException(ErrorCode.SIGNER_CONFIG_EMPTY, "private key not specified");
        }
        Pkcs8KeyOperator pkcs8KeyOperator = new Pkcs8KeyOperator();
        if (isPrivateKeyEmpty) {
            this.privateKey = ResourceUtils.readResourceBytes((String)this.privateKeyPath);
        }
        this.keyPair = pkcs8KeyOperator.load(this.privateKey, this.privateKeyPassword);
    }

    @Override
    public byte[] sign(byte[] message) {
        return this.signer.sign(message);
    }

    @Override
    public boolean verify(byte[] sig, byte[] msg) {
        return this.signer.verify(sig, msg);
    }

    @Override
    public byte[] recover(byte[] sig, byte[] msg) {
        return this.signer.recover(sig, msg);
    }

    @Override
    public void destroy() {
    }
}

