/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.domain.parser;

import com.alipay.chainstack.jbcc.mychainx.model.bizview.BizViewLog;
import com.alipay.chainstack.jbcc.mychainx.model.block.BlockModel;
import com.alipay.chainstack.jbcc.mychainx.model.receipt.ReceiptModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.BaseBAORequest;
import com.alipay.chainstack.jbcc.mychainx.model.response.BaseBAOResponse;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionType;
import com.alipay.mychain.sdk.vm.WASMOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;

public abstract class BaseBlockParser {
    protected BlockModel blockModel;
    protected Map<String, List<TransactionModel>> transactionMap = new HashMap<String, List<TransactionModel>>();
    protected Map<String, List<ReceiptModel>> receiptMap = new HashMap<String, List<ReceiptModel>>();
    protected Set<String> contractIds = new HashSet<String>();

    protected BaseBlockParser() {
    }

    public BaseBlockParser(BlockModel blockModel) {
        this(blockModel, null);
    }

    public BaseBlockParser(BlockModel blockModel, Set<String> contractFilterIds) {
        this.blockModel = blockModel;
        if (contractFilterIds != null) {
            this.contractIds.addAll(contractFilterIds.stream().map(this::parseContractId).collect(Collectors.toSet()));
        }
        this.processBlock(blockModel);
    }

    public abstract List<BaseBAORequest> getAllRequests();

    public abstract List<BaseBAOResponse> getAllResponses();

    public List<BizViewLog> getBizViews() {
        return new ArrayList<BizViewLog>();
    }

    protected void processBlock(BlockModel blockModel) {
        for (int i = 0; i < blockModel.getBlockBody().getTransactionList().size(); ++i) {
            String method;
            TransactionModel transaction = blockModel.getBlockBody().getTransactionList().get(i);
            ReceiptModel receipt = blockModel.getBlockBody().getReceiptList().get(i);
            if (this.isSkip(transaction) || StringUtils.isEmpty((CharSequence)(method = this.getTransactionMethod(transaction)))) continue;
            this.transactionMap.computeIfAbsent(method, m -> new ArrayList());
            this.transactionMap.get(method).add(transaction);
            this.receiptMap.computeIfAbsent(method, m -> new ArrayList());
            this.receiptMap.get(method).add(receipt);
        }
    }

    protected String getTransactionMethod(TransactionModel transactionModel) {
        try {
            WASMOutput output = new WASMOutput(Hex.toHexString((byte[])transactionModel.getData()));
            return output.getString();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String parseContractId(String contractId) {
        if (contractId == null) {
            throw new RuntimeException("contract id cannot be null");
        }
        if ((contractId = contractId.trim()).startsWith("0X") || contractId.startsWith("0x")) {
            return contractId.substring(2).toLowerCase();
        }
        return contractId.toLowerCase();
    }

    protected boolean isSkip(TransactionModel transaction) {
        return transaction == null || this.contractIds.size() > 0 && (transaction.getTo() == null || !this.contractIds.contains(transaction.getTo().hexStrValue().toLowerCase())) || !TransactionType.TX_CALL_CONTRACT.equals((Object)transaction.getTxType());
    }

    protected boolean hasRequest(String method) {
        return this.transactionMap.containsKey(method);
    }
}

