/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.domain.parser;

import com.alipay.chainstack.jbcc.mychainx.model.bizview.BizViewLog;
import com.alipay.chainstack.jbcc.mychainx.model.log.ContractLog;
import com.alipay.chainstack.jbcc.mychainx.model.log.LogModel;
import com.alipay.chainstack.jbcc.mychainx.model.receipt.ReceiptModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.BaseBAORequest;
import com.alipay.chainstack.jbcc.mychainx.model.response.BaseBAOResponse;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseTransactionParser {
    protected TransactionModel transactionModel;
    protected ReceiptModel receiptModel;

    protected BaseTransactionParser() {
    }

    public BaseTransactionParser(ReceiptModel receiptModel) {
        this.receiptModel = receiptModel;
    }

    public BaseTransactionParser(TransactionModel transactionModel) {
        this.transactionModel = transactionModel;
    }

    public BaseTransactionParser(TransactionModel transactionModel, ReceiptModel receiptModel) {
        this.transactionModel = transactionModel;
        this.receiptModel = receiptModel;
    }

    public abstract BaseBAORequest parseRequest();

    public abstract BaseBAOResponse parseResponse();

    public List<BizViewLog> getBizViews() {
        return new ArrayList<BizViewLog>();
    }

    public List<ContractLog> getContractLogs() {
        ArrayList<ContractLog> logs = new ArrayList<ContractLog>();
        for (LogModel logModel : this.receiptModel.getLogs()) {
            ContractLog log = ContractLog.decodeFromLogEntry(logModel);
            if (null == log) continue;
            logs.add(log);
        }
        return logs;
    }
}

