/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.exception.error;

import com.alipay.chainstack.jbcc.mychainx.exception.error.IErrorCode;

public enum ErrorCode implements IErrorCode
{
    SUCCESS(0, "SUCCESS"),
    INTERNAL_ERROR(10000, "rich client internal error"),
    SIGNER_CONFIG_EMPTY(10001, "rich client signer config is empty"),
    SIGNER_CONFIG_INVALID(10002, "rich client signer config is invalid"),
    SIGNER_NOT_FOUND(10003, "rich client signer is not found"),
    CLIENT_OPTION_INVALID(10004, "client config is invalid"),
    CONTRACT_INIT_FAIL(10005, "contract initialization failed"),
    CHAIN_CLIENT_NOT_SET(10006, "chain client is not set"),
    ACCOUNT_KEY_EMPTY_INVALID(10007, "account keys are empty"),
    TX_PROCESS_FAIL(10008, "blockchain service failed to process transaction"),
    INVALID_SUBNET_ID(10009, "length of subnet id must exactly 8 characters hex string (4 bytes)");

    private int value;
    private String desc;

    private ErrorCode(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getErrorCode() {
        return this.value;
    }

    @Override
    public String getErrorDesc() {
        return String.valueOf(this.desc);
    }

    @Override
    public boolean isSuccess() {
        return this == SUCCESS;
    }

    @Override
    public String toString() {
        return "ErrorCode{value=" + this.value + ", desc='" + this.desc + '\'' + '}';
    }
}

