/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.account;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.chainstack.jbcc.mychainx.model.IMychainObject;
import com.alipay.chainstack.jbcc.mychainx.model.account.AccountStatus;
import com.alipay.chainstack.jbcc.mychainx.model.account.AuthMap;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import com.google.common.base.Charsets;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;

public class AccountModel
implements IMychainObject<AccountModel> {
    protected short version = (short)2;
    private Identity id = new Identity();
    private BigInteger balance = BigInteger.ZERO;
    private AuthMap authMap = new AuthMap();
    private PublicKey recoverKey = new PublicKey();
    private long recoverTimestamp = 0L;
    private AccountStatus status = AccountStatus.NORMAL;
    private byte[] encryptionKey = new byte[0];

    public Identity getIdentity() {
        return this.id;
    }

    public AccountModel setIdentity(Identity id) {
        this.id = id;
        return this;
    }

    public BigInteger getBalance() {
        return this.balance;
    }

    public AccountModel setBalance(BigInteger balance) {
        this.balance = balance;
        return this;
    }

    public AuthMap getAuthMap() {
        return this.authMap;
    }

    public AccountModel setAuthMap(AuthMap authMap) {
        this.authMap = authMap;
        return this;
    }

    public PublicKey getRecoverKey() {
        return this.recoverKey;
    }

    public AccountModel setRecoverKey(PublicKey recoverKey) {
        this.recoverKey = recoverKey;
        return this;
    }

    public long getRecoverTimestamp() {
        return this.recoverTimestamp;
    }

    public AccountModel setRecoverTimestamp(long recoverTimestamp) {
        this.recoverTimestamp = recoverTimestamp;
        return this;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public AccountModel setStatus(AccountStatus status) {
        this.status = status;
        return this;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public AccountModel setEncryptionKey(byte[] encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public short getVersion() {
        return this.version;
    }

    public AccountModel setVersion(short version) {
        this.version = version;
        return this;
    }

    @Override
    public byte[] toRlp() {
        byte[] identityBytes = Rlp.encodeElement((byte[])this.id.getValue());
        byte[] balanceBytes = Rlp.encodeBigInteger((BigInteger)this.balance);
        byte[] recoverKeyBytes = Rlp.encodeElement((byte[])this.recoverKey.getValue());
        byte[] recoverTimeBytes = Rlp.encodeLong((long)this.recoverTimestamp);
        byte[] statusBytes = Rlp.encodeInt((int)this.status.getValue());
        byte[] code = Rlp.encodeElement((byte[])ArrayUtils.EMPTY_BYTE_ARRAY);
        byte[] storageRootBytes = Rlp.encodeElement((byte[])new Identity().getValue());
        byte[] codeHash = Rlp.encodeElement((byte[])new Identity().getValue());
        byte[] encryptionKeyBytes = this.encryptionKey == null ? Rlp.encodeElement((byte[])ArrayUtils.EMPTY_BYTE_ARRAY) : Rlp.encodeElement((byte[])this.encryptionKey);
        byte[] versionBytes = Rlp.encodeList((byte[][])new byte[][]{Rlp.encodeInt((int)this.version)});
        byte[] authMapBytes = Rlp.encodeElement((byte[])this.authMap.toRlp());
        return Rlp.encodeList((byte[][])new byte[][]{identityBytes, balanceBytes, recoverKeyBytes, recoverTimeBytes, statusBytes, code, storageRootBytes, codeHash, encryptionKeyBytes, versionBytes, authMapBytes});
    }

    @Override
    public AccountModel fromRlp(RlpList rlp) {
        this.id = new Identity(((RlpElement)rlp.get(0)).getRlpData());
        this.balance = ByteUtils.byteArrayToBigInteger((byte[])((RlpElement)rlp.get(1)).getRlpData());
        this.recoverKey = new PublicKey(((RlpElement)rlp.get(2)).getRlpData());
        this.recoverTimestamp = ByteUtils.byteArrayToLong((byte[])((RlpElement)rlp.get(3)).getRlpData());
        this.status = AccountStatus.valueOf(ByteUtils.byteArrayToInt((byte[])((RlpElement)rlp.get(4)).getRlpData()));
        this.encryptionKey = ((RlpElement)rlp.get(8)).getRlpData();
        this.version = ByteUtils.bytesToShort((byte[])((RlpElement)((RlpList)rlp.get(9)).get(0)).getRlpData());
        this.authMap.fromRlp((RlpList)Rlp.decode2((byte[])((RlpElement)rlp.get(10)).getRlpData()).get(0));
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)ByteUtils.toHexString((byte[])this.id.getValue()));
        jsonObject.put("balance", (Object)this.balance);
        jsonObject.put("recovery_key", (Object)ByteUtils.toHexString((byte[])this.recoverKey.getValue()));
        jsonObject.put("recovery_time", (Object)this.recoverTimestamp);
        jsonObject.put("status", (Object)this.status.getValue());
        jsonObject.put("encryption_key", (Object)ByteUtils.toHexString((byte[])this.encryptionKey));
        jsonObject.put("version", (Object)this.version);
        JSONArray array = this.authMap.toJson();
        jsonObject.put("auth_map", (Object)array);
        return jsonObject;
    }

    @Override
    public AccountModel fromJson(JSONObject jsonObject) {
        this.id = new Identity(jsonObject.getString("id"));
        this.balance = jsonObject.getBigInteger("balance");
        this.recoverKey = new PublicKey(jsonObject.getString("recovery_key"));
        this.recoverTimestamp = jsonObject.getLong("recovery_time");
        this.status = AccountStatus.valueOf(jsonObject.getIntValue("status"));
        this.encryptionKey = ByteUtils.hexStringToBytes((String)jsonObject.getString("encryption_key"));
        this.version = jsonObject.getShort("version");
        this.authMap.fromJson(jsonObject.getJSONArray("auth_map"));
        return this;
    }

    public String toString() {
        return "AccountModel{version=" + this.version + ", id=" + this.id.hexStrValue() + ", balance=" + this.balance + ", authMap=" + this.authMap + ", recoverKey=" + this.recoverKey.hexStrValue() + ", recoverTimestamp=" + this.recoverTimestamp + ", status=" + this.status + ", encryptionKey=" + new String(this.encryptionKey, Charsets.UTF_8) + '}';
    }
}

