/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.account;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class AuthMap
implements Serializable {
    private static final long serialVersionUID = -3309297039357729846L;
    private Map<PublicKey, Integer> authMap = new LinkedHashMap<PublicKey, Integer>(1);

    public Map<PublicKey, Integer> getAuthMap() {
        return this.authMap;
    }

    public AuthMap setAuthMap(Map<PublicKey, Integer> authMap) {
        this.authMap = authMap;
        return this;
    }

    public AuthMap updateAuth(PublicKey authKey, Integer authWeight) {
        if (null == authKey || null == authWeight) {
            return this;
        }
        this.authMap.put(authKey, authWeight);
        return this;
    }

    public AuthMap deleteAuth(PublicKey authKey) {
        if (null == authKey || !this.authMap.containsKey(authKey)) {
            return this;
        }
        this.authMap.remove(authKey);
        return this;
    }

    public boolean isValid() {
        if (this.authMap == null) {
            return false;
        }
        Integer totalWeight = 0;
        for (Map.Entry<PublicKey, Integer> entry : this.authMap.entrySet()) {
            totalWeight = totalWeight + entry.getValue();
        }
        return totalWeight >= 100;
    }

    public byte[] toRlp() {
        ArrayList<byte[]> listData = new ArrayList<byte[]>();
        for (Map.Entry<PublicKey, Integer> entry : this.authMap.entrySet()) {
            listData.add(Rlp.encodeElement((byte[])entry.getKey().getValue()));
            listData.add(Rlp.encodeInt((int)entry.getValue()));
        }
        return Rlp.encodeList(listData);
    }

    public AuthMap fromRlp(RlpList list) {
        int length = list.size() / 2;
        for (int i = 0; i < length; ++i) {
            this.authMap.put(new PublicKey(((RlpElement)list.get(i * 2)).getRlpData()), ByteUtils.byteArrayToInt((byte[])((RlpElement)list.get(i * 2 + 1)).getRlpData()));
        }
        return this;
    }

    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<PublicKey, Integer> entry : this.authMap.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("key", (Object)ByteUtils.toHexString((byte[])entry.getKey().getValue()));
            jsonObject.put("value", (Object)entry.getValue());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public AuthMap fromJson(JSONArray jsonArray) {
        if (jsonArray != null) {
            for (Object o : jsonArray) {
                JSONObject jsonObject = (JSONObject)o;
                this.authMap.put(new PublicKey(jsonObject.getString("key")), jsonObject.getInteger("value"));
            }
        }
        return this;
    }

    public String toString() {
        return "AuthMap{authMap=" + this.toJson().toJSONString() + '}';
    }
}

