/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.acl;

import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.mychain.sdk.domain.contract.ContractAccessControl;

public class ContractACL {
    private Identity contract;
    private boolean dataRead = false;
    private boolean dataWrite = false;
    private boolean schemaRead = false;
    private boolean schemaWrite = false;

    public ContractACL() {
    }

    public ContractACL(Identity contract) {
        this.contract = contract;
    }

    public boolean isDataRead() {
        return this.dataRead;
    }

    public ContractACL setDataRead(boolean dataRead) {
        this.dataRead = dataRead;
        return this;
    }

    public boolean isDataWrite() {
        return this.dataWrite;
    }

    public ContractACL setDataWrite(boolean dataWrite) {
        this.dataWrite = dataWrite;
        return this;
    }

    public boolean isSchemaRead() {
        return this.schemaRead;
    }

    public ContractACL setSchemaRead(boolean schemaRead) {
        this.schemaRead = schemaRead;
        return this;
    }

    public boolean isSchemaWrite() {
        return this.schemaWrite;
    }

    public ContractACL setSchemaWrite(boolean schemaWrite) {
        this.schemaWrite = schemaWrite;
        return this;
    }

    public Identity getContract() {
        return this.contract;
    }

    public ContractACL setContract(Identity contract) {
        this.contract = contract;
        return this;
    }

    public ContractAccessControl toAccessControl() {
        ContractAccessControl contractAccessControl = new ContractAccessControl();
        contractAccessControl.setDataRead(this.dataRead);
        contractAccessControl.setDataWrite(this.dataWrite);
        contractAccessControl.setSchemaRead(this.schemaRead);
        contractAccessControl.setSchemaWrite(this.schemaWrite);
        contractAccessControl.setContractId(new com.alipay.mychain.sdk.domain.account.Identity(this.contract.hexStrValue()));
        return contractAccessControl;
    }

    public static ContractACL fromACLByte(byte acl) {
        ContractAccessControl contractAccessControl = new ContractAccessControl(acl);
        ContractACL contractACL = new ContractACL();
        contractACL.setDataRead(contractAccessControl.isDataRead());
        contractACL.setDataWrite(contractAccessControl.isDataWrite());
        contractACL.setSchemaRead(contractAccessControl.isSchemaRead());
        contractACL.setSchemaWrite(contractAccessControl.isSchemaWrite());
        return contractACL;
    }

    public String toString() {
        return "ContractACL{contract=" + (Object)((Object)this.contract) + ", dataRead=" + this.dataRead + ", dataWrite=" + this.dataWrite + ", schemaRead=" + this.schemaRead + ", schemaWrite=" + this.schemaWrite + '}';
    }
}

