/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.bizview;

import com.alibaba.fastjson.JSONObject;
import com.alipay.chainstack.commons.utils.JsonUtils;
import com.alipay.chainstack.commons.utils.ReflectionUtil;
import com.alipay.chainstack.jbcc.mychainx.model.bizview.BinLog;
import com.alipay.chainstack.jbcc.mychainx.model.log.LogModel;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.vm.WASMOutput;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;

public class BizViewLog {
    public static final String BIZ_VIEW_TOPIC = "BizView";
    public static final String BIZ_VIEW_TOPIC_HEX = Hex.toHexString((byte[])"BizView".getBytes(StandardCharsets.UTF_8));
    private static final String VERSION_FIELD = "version";
    private static final String BIZ_ID_FIELD = "bizId";
    private static final String E2E_CONTEXT_FIELD = "e2eContext";
    private static final String BIN_LOG_FIELD = "binLog";
    private static final String TX_INDEX_FIELD = "txIndex";
    private static final String TX_HASH_FIELD = "txHash";
    private static final String BLOCK_NUMBER_FIELD = "blockNumber";
    protected BigInteger blockNumber;
    protected int txIndex;
    protected Hash txHash;
    protected Long version;
    protected String bizId;
    protected BinLog binLog;
    protected LogModel rawLog;
    protected Map<String, String> e2eContext;

    public static boolean ifBizViewLog(LogModel logModel) {
        return logModel.getTopics().stream().anyMatch(BIZ_VIEW_TOPIC_HEX::equals);
    }

    public LogModel getRawLog() {
        return this.rawLog;
    }

    public BizViewLog setRawLog(LogModel rawLog) {
        this.rawLog = rawLog;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public BizViewLog setVersion(Long version) {
        this.version = version;
        return this;
    }

    public String getBizId() {
        return this.bizId;
    }

    public BizViewLog setBizId(String bizId) {
        this.bizId = bizId;
        return this;
    }

    public BinLog getBinLog() {
        return this.binLog;
    }

    public BizViewLog setBinLog(BinLog binLog) {
        this.binLog = binLog;
        return this;
    }

    public Map<String, String> getE2eContext() {
        return this.e2eContext;
    }

    public BizViewLog setE2eContext(Map<String, String> e2eContext) {
        this.e2eContext = e2eContext;
        return this;
    }

    public BinLog getBinLogData() {
        return null;
    }

    public BizViewLog setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
        return this;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public BizViewLog setTxIndex(int txIndex) {
        this.txIndex = txIndex;
        return this;
    }

    public int getTxIndex() {
        return this.txIndex;
    }

    public BizViewLog setTxHash(Hash txHash) {
        this.txHash = txHash;
        return this;
    }

    public Hash getTxHash() {
        return this.txHash;
    }

    public static BizViewLog decodeFromLog(LogModel log) {
        byte[] logData = log.getLogData();
        WASMOutput output = new WASMOutput(Hex.toHexString((byte[])logData));
        String bizViewJson = output.getString();
        BizViewLog bizViewLog = new BizViewLog();
        bizViewLog.rawLog = log;
        JSONObject bizViewJsonObject = JsonUtils.parseObject((String)bizViewJson);
        bizViewLog.version = bizViewJsonObject.getLong(VERSION_FIELD);
        bizViewLog.bizId = bizViewJsonObject.getString(BIZ_ID_FIELD);
        JSONObject e2eContextObject = bizViewJsonObject.getJSONObject(E2E_CONTEXT_FIELD);
        bizViewLog.e2eContext = e2eContextObject == null ? new HashMap<String, String>() : e2eContextObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue()));
        JSONObject binLogObject = bizViewJsonObject.getJSONObject(BIN_LOG_FIELD);
        bizViewLog.binLog = new BinLog();
        bizViewLog.binLog.setRawData(binLogObject.getString("data"));
        bizViewLog.binLog.setBinLogType(binLogObject.getString("type"));
        return bizViewLog;
    }

    public <T> T toBizViewLogVO(Class<T> voClass) {
        return this.withBaseProperties(voClass);
    }

    protected <T> T withBaseProperties(Class<T> voClass) {
        try {
            T bizViewLogVO = voClass.newInstance();
            ReflectionUtil.setPropertyWithFallback(bizViewLogVO, (String)VERSION_FIELD, (Object)this.getVersion());
            ReflectionUtil.setPropertyWithFallback(bizViewLogVO, (String)BIZ_ID_FIELD, (Object)this.getBizId());
            ReflectionUtil.setPropertyWithFallback(bizViewLogVO, (String)E2E_CONTEXT_FIELD, this.getE2eContext());
            ReflectionUtil.setPropertyWithFallback(bizViewLogVO, (String)TX_INDEX_FIELD, (Object)this.getTxIndex());
            ReflectionUtil.setPropertyWithFallback(bizViewLogVO, (String)TX_HASH_FIELD, (Object)this.getTxHash().hexStrValue());
            ReflectionUtil.setPropertyWithFallback(bizViewLogVO, (String)BLOCK_NUMBER_FIELD, (Object)this.getBlockNumber());
            return bizViewLogVO;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to convert bao response to response vo", e);
        }
    }
}

