/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.block;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.chainstack.jbcc.mychainx.model.IMychainObject;
import com.alipay.chainstack.jbcc.mychainx.model.receipt.ReceiptModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class BlockBodyModel
implements IMychainObject<BlockBodyModel> {
    private List<TransactionModel> transactionList;
    private List<ReceiptModel> receiptList;
    private byte[] consensusProof;

    public List<TransactionModel> getTransactionList() {
        return this.transactionList;
    }

    public BlockBodyModel setTransactionList(List<TransactionModel> transactionList) {
        this.transactionList = transactionList;
        return this;
    }

    public List<ReceiptModel> getReceiptList() {
        return this.receiptList;
    }

    public BlockBodyModel setReceiptList(List<ReceiptModel> receiptList) {
        this.receiptList = receiptList;
        return this;
    }

    public byte[] getConsensusProof() {
        return this.consensusProof;
    }

    public BlockBodyModel setConsensusProof(byte[] consensusProof) {
        this.consensusProof = consensusProof;
        return this;
    }

    @Override
    public byte[] toRlp() {
        ArrayList<byte[]> txData = new ArrayList<byte[]>();
        for (TransactionModel item : this.transactionList) {
            txData.add(item.toRlp());
        }
        ArrayList<byte[]> receiptData = new ArrayList<byte[]>();
        for (ReceiptModel item : this.receiptList) {
            receiptData.add(item.toRlp());
        }
        return Rlp.encodeList((byte[][])new byte[][]{Rlp.encodeList(txData), Rlp.encodeList(receiptData), Rlp.encodeElement((byte[])this.consensusProof)});
    }

    @Override
    public BlockBodyModel fromRlp(RlpList list) {
        this.transactionList = new ArrayList<TransactionModel>();
        RlpList txList = (RlpList)list.get(0);
        for (RlpElement element : txList) {
            TransactionModel item = new TransactionModel();
            item.fromRlp((RlpList)element);
            this.transactionList.add(item);
        }
        this.receiptList = new ArrayList<ReceiptModel>();
        RlpList receiptList = (RlpList)list.get(1);
        for (RlpElement element : receiptList) {
            ReceiptModel item = new ReceiptModel();
            item.fromRlp((RlpList)element);
            this.receiptList.add(item);
        }
        this.consensusProof = ((RlpElement)list.get(2)).getRlpData();
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONArray txArray = new JSONArray();
        if (this.transactionList != null) {
            for (TransactionModel item : this.transactionList) {
                JSONObject object = item.toJson();
                txArray.add((Object)object);
            }
        }
        JSONArray receiptArray = new JSONArray();
        if (this.receiptList != null) {
            for (ReceiptModel item : this.receiptList) {
                JSONObject object = item.toJson();
                receiptArray.add((Object)object);
            }
        }
        jsonObject.put("transaction_list", (Object)txArray);
        jsonObject.put("receipt_list", (Object)receiptArray);
        jsonObject.put("consensus_proof", (Object)ByteUtils.toHexString((byte[])this.consensusProof));
        return jsonObject;
    }

    @Override
    public BlockBodyModel fromJson(JSONObject jsonObject) {
        this.transactionList = new ArrayList<TransactionModel>();
        JSONArray txArray = jsonObject.getJSONArray("transaction_list");
        if (txArray != null) {
            for (Object o : txArray) {
                TransactionModel object = new TransactionModel();
                object.fromJson((JSONObject)o);
                this.transactionList.add(object);
            }
        }
        this.receiptList = new ArrayList<ReceiptModel>();
        JSONArray receiptArray = jsonObject.getJSONArray("receipt_list");
        if (receiptArray != null) {
            for (Object o : receiptArray) {
                ReceiptModel object = new ReceiptModel();
                object.fromJson((JSONObject)o);
                this.receiptList.add(object);
            }
        }
        this.consensusProof = ByteUtils.hexStringToBytes((String)jsonObject.getString("consensus_proof"));
        return this;
    }

    public String toString() {
        return "BlockBodyModel{transactionList=" + this.transactionList + ", receiptList=" + this.receiptList + ", consensusProof=" + (this.consensusProof == null ? null : Hex.toHexString((byte[])this.consensusProof)) + '}';
    }
}

