/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.block;

import com.alibaba.fastjson.JSONObject;
import com.alipay.chainstack.jbcc.mychainx.model.IMychainObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import org.bouncycastle.util.encoders.Hex;

public class BlockHeaderModel
implements IMychainObject<BlockHeaderModel> {
    private Hash hash = new Hash();
    private Hash parentHash = new Hash();
    private Hash transactionRoot = new Hash();
    private Hash receiptRoot = new Hash();
    private Hash stateRoot = new Hash();
    private Long version;
    private BigInteger number;
    private BigInteger gasUsed;
    private long timestamp;
    private byte[] logBloom;

    public Hash getHash() {
        return this.hash;
    }

    public BlockHeaderModel setHash(Hash hash) {
        this.hash = hash;
        return this;
    }

    public Hash getParentHash() {
        return this.parentHash;
    }

    public BlockHeaderModel setParentHash(Hash parentHash) {
        this.parentHash = parentHash;
        return this;
    }

    public Hash getTransactionRoot() {
        return this.transactionRoot;
    }

    public BlockHeaderModel setTransactionRoot(Hash transactionRoot) {
        this.transactionRoot = transactionRoot;
        return this;
    }

    public Hash getReceiptRoot() {
        return this.receiptRoot;
    }

    public BlockHeaderModel setReceiptRoot(Hash receiptRoot) {
        this.receiptRoot = receiptRoot;
        return this;
    }

    public Hash getStateRoot() {
        return this.stateRoot;
    }

    public BlockHeaderModel setStateRoot(Hash stateRoot) {
        this.stateRoot = stateRoot;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public BlockHeaderModel setVersion(Long version) {
        this.version = version;
        return this;
    }

    public BigInteger getNumber() {
        return this.number;
    }

    public BlockHeaderModel setNumber(BigInteger number) {
        this.number = number;
        return this;
    }

    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    public BlockHeaderModel setGasUsed(BigInteger gasUsed) {
        this.gasUsed = gasUsed;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BlockHeaderModel setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public byte[] getLogBloom() {
        return this.logBloom;
    }

    public BlockHeaderModel setLogBloom(byte[] logBloom) {
        this.logBloom = logBloom;
        return this;
    }

    @Override
    public byte[] toRlp() {
        byte[] hashBytes = Rlp.encodeElement((byte[])this.hash.getValue());
        byte[] versionBytes = Rlp.encodeLong((long)this.version);
        byte[] numberBytes = Rlp.encodeBigInteger((BigInteger)this.number);
        byte[] parentHashBytes = Rlp.encodeElement((byte[])this.parentHash.getValue());
        byte[] transactionRootBytes = Rlp.encodeElement((byte[])this.transactionRoot.getValue());
        byte[] receiptRootBytes = Rlp.encodeElement((byte[])this.receiptRoot.getValue());
        byte[] stateRootBytes = Rlp.encodeElement((byte[])this.stateRoot.getValue());
        byte[] gasUsedBytes = Rlp.encodeBigInteger((BigInteger)this.gasUsed);
        byte[] timestampBytes = Rlp.encodeLong((long)this.timestamp);
        byte[] logBloomBytes = Rlp.encodeElement((byte[])this.logBloom);
        return Rlp.encodeList((byte[][])new byte[][]{hashBytes, versionBytes, numberBytes, parentHashBytes, transactionRootBytes, receiptRootBytes, stateRootBytes, gasUsedBytes, timestampBytes, logBloomBytes});
    }

    @Override
    public BlockHeaderModel fromRlp(RlpList list) {
        this.hash = new Hash(((RlpElement)list.get(0)).getRlpData());
        this.version = ByteUtils.byteArrayToLong((byte[])((RlpElement)list.get(1)).getRlpData());
        this.number = ByteUtils.byteArrayToBigInteger((byte[])((RlpElement)list.get(2)).getRlpData());
        this.parentHash = new Hash(((RlpElement)list.get(3)).getRlpData());
        this.transactionRoot = new Hash(((RlpElement)list.get(4)).getRlpData());
        this.receiptRoot = new Hash(((RlpElement)list.get(5)).getRlpData());
        this.stateRoot = new Hash(((RlpElement)list.get(6)).getRlpData());
        this.gasUsed = ByteUtils.byteArrayToBigInteger((byte[])((RlpElement)list.get(7)).getRlpData());
        this.timestamp = ByteUtils.byteArrayToLong((byte[])((RlpElement)list.get(8)).getRlpData());
        this.logBloom = ((RlpElement)list.get(9)).getRlpData();
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("hash", (Object)ByteUtils.toHexString((byte[])this.hash.getValue()));
        jsonObject.put("version", (Object)this.version);
        jsonObject.put("number", (Object)this.number);
        jsonObject.put("parent_hash", (Object)ByteUtils.toHexString((byte[])this.parentHash.getValue()));
        jsonObject.put("transaction_root", (Object)ByteUtils.toHexString((byte[])this.transactionRoot.getValue()));
        jsonObject.put("receipt_root", (Object)ByteUtils.toHexString((byte[])this.receiptRoot.getValue()));
        jsonObject.put("state_root", (Object)ByteUtils.toHexString((byte[])this.stateRoot.getValue()));
        jsonObject.put("gas_used", (Object)this.gasUsed);
        jsonObject.put("timestamp", (Object)this.timestamp);
        jsonObject.put("log_bloom", (Object)ByteUtils.toHexString((byte[])this.logBloom));
        return jsonObject;
    }

    @Override
    public BlockHeaderModel fromJson(JSONObject jsonObject) {
        this.hash = new Hash(jsonObject.getString("hash"));
        this.version = jsonObject.getLong("version");
        this.number = jsonObject.getBigInteger("number");
        this.parentHash = new Hash(jsonObject.getString("parent_hash"));
        this.transactionRoot = new Hash(jsonObject.getString("transaction_root"));
        this.receiptRoot = new Hash(jsonObject.getString("receipt_root"));
        this.stateRoot = new Hash(jsonObject.getString("state_root"));
        this.gasUsed = jsonObject.getBigInteger("gas_used");
        this.timestamp = jsonObject.getLong("timestamp");
        this.logBloom = ByteUtils.hexStringToBytes((String)jsonObject.getString("log_bloom"));
        return this;
    }

    public String toString() {
        return "BlockHeaderModel{hash=" + (this.hash == null ? null : this.hash.hexStrValue()) + ", parentHash=" + (this.parentHash == null ? null : this.parentHash.hexStrValue()) + ", transactionRoot=" + (this.transactionRoot == null ? null : this.transactionRoot.hexStrValue()) + ", receiptRoot=" + (this.receiptRoot == null ? null : this.receiptRoot.hexStrValue()) + ", stateRoot=" + (this.stateRoot == null ? null : this.stateRoot.hexStrValue()) + ", version=" + this.version + ", number=" + this.number + ", gasUsed=" + this.gasUsed + ", timestamp=" + this.timestamp + ", logBloom=" + (this.logBloom == null ? null : Hex.toHexString((byte[])this.logBloom)) + '}';
    }
}

