/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.contract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.chainstack.jbcc.mychainx.model.account.AccountModel;
import com.alipay.chainstack.jbcc.mychainx.model.account.AccountStatus;
import com.alipay.chainstack.jbcc.mychainx.model.account.AuthMap;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;

public class ContractModel
extends AccountModel {
    private Hash storageRoot = new Hash();
    private Hash codeHash = new Hash();
    private byte[] code;

    public Hash getStorageRoot() {
        return this.storageRoot;
    }

    public ContractModel setStorageRoot(Hash storageRoot) {
        this.storageRoot = storageRoot;
        return this;
    }

    public Hash getCodeHash() {
        return this.codeHash;
    }

    public ContractModel setCodeHash(Hash codeHash) {
        this.codeHash = codeHash;
        return this;
    }

    public byte[] getCode() {
        return this.code;
    }

    public ContractModel setCode(byte[] code) {
        this.code = code;
        return this;
    }

    @Override
    public byte[] toRlp() {
        byte[] identityBytes = Rlp.encodeElement((byte[])this.getIdentity().getValue());
        byte[] balanceBytes = Rlp.encodeBigInteger((BigInteger)this.getBalance());
        byte[] recoverKeyBytes = Rlp.encodeElement((byte[])this.getRecoverKey().getValue());
        byte[] recoverTimeBytes = Rlp.encodeLong((long)this.getRecoverTimestamp());
        byte[] statusBytes = Rlp.encodeInt((int)this.getStatus().getValue());
        byte[] codeBytes = Rlp.encodeElement((byte[])this.code);
        byte[] storageRootBytes = Rlp.encodeElement((byte[])this.storageRoot.getValue());
        byte[] codeHashBytes = Rlp.encodeElement((byte[])this.codeHash.getValue());
        byte[] encryptionKeyBytes = this.getEncryptionKey() == null ? Rlp.encodeElement((byte[])ArrayUtils.EMPTY_BYTE_ARRAY) : Rlp.encodeElement((byte[])this.getEncryptionKey());
        byte[] versionBytes = Rlp.encodeList((byte[][])new byte[][]{Rlp.encodeInt((int)this.getVersion())});
        byte[] authMapBytes = Rlp.encodeElement((byte[])this.getAuthMap().toRlp());
        return Rlp.encodeList((byte[][])new byte[][]{identityBytes, balanceBytes, recoverKeyBytes, recoverTimeBytes, statusBytes, codeBytes, storageRootBytes, codeHashBytes, encryptionKeyBytes, versionBytes, authMapBytes});
    }

    @Override
    public ContractModel fromRlp(RlpList list) {
        this.setIdentity(new Identity(((RlpElement)list.get(0)).getRlpData()));
        this.setBalance(ByteUtils.byteArrayToBigInteger((byte[])((RlpElement)list.get(1)).getRlpData()));
        this.setRecoverKey(new PublicKey(((RlpElement)list.get(2)).getRlpData()));
        this.setRecoverTimestamp(ByteUtils.byteArrayToLong((byte[])((RlpElement)list.get(3)).getRlpData()));
        this.setStatus(AccountStatus.valueOf(ByteUtils.byteArrayToInt((byte[])((RlpElement)list.get(4)).getRlpData())));
        this.code = ((RlpElement)list.get(5)).getRlpData();
        this.storageRoot = new Hash(((RlpElement)list.get(6)).getRlpData());
        this.codeHash = new Hash(((RlpElement)list.get(7)).getRlpData());
        this.setEncryptionKey(((RlpElement)list.get(8)).getRlpData());
        this.setVersion(ByteUtils.bytesToShort((byte[])((RlpElement)((RlpList)list.get(9)).get(0)).getRlpData()));
        AuthMap authMap = new AuthMap();
        authMap.fromRlp((RlpList)Rlp.decode2((byte[])((RlpElement)list.get(10)).getRlpData()).get(0));
        this.setAuthMap(authMap);
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)ByteUtils.toHexString((byte[])this.getIdentity().getValue()));
        jsonObject.put("balance", (Object)this.getBalance());
        jsonObject.put("recovery_key", (Object)ByteUtils.toHexString((byte[])this.getRecoverKey().getValue()));
        jsonObject.put("recovery_time", (Object)this.getRecoverTimestamp());
        jsonObject.put("status", (Object)this.getStatus().getValue());
        jsonObject.put("code", (Object)ByteUtils.toHexString((byte[])this.code));
        jsonObject.put("storage_root", (Object)ByteUtils.toHexString((byte[])this.storageRoot.getValue()));
        jsonObject.put("code_hash", (Object)ByteUtils.toHexString((byte[])this.codeHash.getValue()));
        jsonObject.put("encryption_key", (Object)ByteUtils.toHexString((byte[])this.getEncryptionKey()));
        jsonObject.put("version", (Object)this.getVersion());
        JSONArray array = this.getAuthMap().toJson();
        jsonObject.put("auth_map", (Object)array);
        return jsonObject;
    }

    @Override
    public ContractModel fromJson(JSONObject jsonObject) {
        this.setIdentity(new Identity(jsonObject.getString("id")));
        this.setBalance(jsonObject.getBigInteger("balance"));
        this.setRecoverKey(new PublicKey(jsonObject.getString("recovery_key")));
        this.setRecoverTimestamp(jsonObject.getLong("recovery_time"));
        this.setStatus(AccountStatus.valueOf(jsonObject.getIntValue("status")));
        this.code = ByteUtils.hexStringToBytes((String)jsonObject.getString("code"));
        this.storageRoot = new Hash(jsonObject.getString("storage_root"));
        this.codeHash = new Hash(jsonObject.getString("code_hash"));
        this.setEncryptionKey(ByteUtils.hexStringToBytes((String)jsonObject.getString("encryption_key")));
        this.setVersion(jsonObject.getShort("version"));
        this.getAuthMap().fromJson(jsonObject.getJSONArray("auth_map"));
        return this;
    }

    @Override
    public String toString() {
        return "ContractModel{storageRoot=" + this.storageRoot.hexStrValue() + ", codeHash=" + this.codeHash.hexStrValue() + ", code=" + Hex.toHexString((byte[])this.code) + '}';
    }
}

