/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.contract;

import com.alipay.mychain.sdk.common.VMTypeEnum;

public enum ContractTypeEnum {
    NATIVE(VMTypeEnum.NATIVE, "so"),
    EVM(VMTypeEnum.EVM, "bin"),
    WASM(VMTypeEnum.WASM, "wasc"),
    NATIVE_PRECOMPILE(VMTypeEnum.NATIVE, "so");

    private final VMTypeEnum vmTypeEnum;
    private final String extension;

    private ContractTypeEnum(VMTypeEnum vmTypeEnum, String extension) {
        this.vmTypeEnum = vmTypeEnum;
        this.extension = extension;
    }

    public VMTypeEnum getVmType() {
        return this.vmTypeEnum;
    }

    public String getExtension() {
        return this.extension;
    }

    public static ContractTypeEnum getByExtension(String extension) {
        for (ContractTypeEnum en : ContractTypeEnum.values()) {
            if (!en.extension.equals(extension)) continue;
            return en;
        }
        return null;
    }
}

