/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.log;

import com.alipay.chainstack.jbcc.mychainx.model.log.LogDO;
import com.alipay.chainstack.jbcc.mychainx.model.log.LogModel;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicBytes;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class ContractLog
extends LogDO {
    public static final String STP_LOGGER_LOG = "___Logger___";
    public static final String STP_LOGGER_LOG_HEX = Hex.toHexString((byte[])"___Logger___".getBytes());
    public static final String LEVEL_TRACE = "trace";
    public static final String LEVEL_DEBUG = "debug";
    public static final String LEVEL_INFO = "info";
    public static final String LEVEL_WARN = "warn";
    public static final String LEVEL_ERROR = "error";
    private long level;
    private String levelName;
    private String msg;

    @Override
    public String getTopic() {
        return STP_LOGGER_LOG;
    }

    @Override
    public String getTopicHex() {
        return STP_LOGGER_LOG_HEX;
    }

    public static boolean ifLogger(LogModel logModel) {
        return logModel.getTopics() != null && !logModel.getTopics().isEmpty() && logModel.getTopics().get(0).equals(STP_LOGGER_LOG_HEX);
    }

    public static ContractLog decodeFromLogEntry(LogModel logModel) {
        if (!ContractLog.ifLogger(logModel)) {
            return null;
        }
        List<DynamicBytes> logFields = ContractLog.toDynamicBytesList(logModel);
        ContractLog log = new ContractLog();
        log.setLogModel(logModel);
        log.setLevel(ContractLog.toUint32(logFields.get(0)).longValue());
        log.setMsg(ContractLog.toString(logFields.get(1)));
        switch ((int)log.getLevel()) {
            case 0: {
                log.setLevelName(LEVEL_TRACE);
                break;
            }
            case 1: {
                log.setLevelName(LEVEL_DEBUG);
                break;
            }
            case 2: {
                log.setLevelName(LEVEL_INFO);
                break;
            }
            case 3: {
                log.setLevelName(LEVEL_WARN);
                break;
            }
            case 4: {
                log.setLevelName(LEVEL_ERROR);
                break;
            }
        }
        return log;
    }

    public long getLevel() {
        return this.level;
    }

    public void setLevel(long level) {
        this.level = level;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }
}

