/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.log;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.chainstack.jbcc.mychainx.model.IMychainObject;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class LogModel
implements IMychainObject<LogModel> {
    private Identity from;
    private Identity to;
    private List<String> topics = new ArrayList<String>();
    private byte[] logData;

    public Identity getFrom() {
        return this.from;
    }

    public LogModel setFrom(Identity from) {
        this.from = from;
        return this;
    }

    public Identity getTo() {
        return this.to;
    }

    public LogModel setTo(Identity to) {
        this.to = to;
        return this;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public LogModel setTopics(List<String> topics) {
        this.topics = topics;
        return this;
    }

    public byte[] getLogData() {
        return this.logData;
    }

    public LogModel setLogData(byte[] logData) {
        this.logData = logData;
        return this;
    }

    public LogModel copy() {
        byte[] logDataCopy;
        if (this.logData == null) {
            logDataCopy = null;
        } else {
            logDataCopy = new byte[this.logData.length];
            System.arraycopy(this.logData, 0, logDataCopy, 0, this.logData.length);
        }
        return new LogModel().setFrom(this.from == null ? null : new Identity(this.from.getValue())).setTo(this.to == null ? null : new Identity(this.to.getValue())).setLogData(logDataCopy).setTopics((List<String>)(null == this.topics ? null : new ArrayList<String>(this.topics)));
    }

    @Override
    public byte[] toRlp() {
        byte[] fromBytes = Rlp.encodeElement((byte[])this.from.getValue());
        byte[] toBytes = Rlp.encodeElement((byte[])this.to.getValue());
        ArrayList<byte[]> topicList = new ArrayList<byte[]>();
        if (this.topics != null) {
            for (String item : this.topics) {
                topicList.add(Rlp.encodeString((String)item));
            }
        }
        byte[] topicsBytes = Rlp.encodeList(topicList);
        byte[] logDataBytes = Rlp.encodeElement((byte[])this.logData);
        return Rlp.encodeList((byte[][])new byte[][]{fromBytes, toBytes, topicsBytes, logDataBytes});
    }

    @Override
    public LogModel fromRlp(RlpList list) {
        this.from = new Identity(((RlpElement)list.get(0)).getRlpData());
        this.to = new Identity(((RlpElement)list.get(1)).getRlpData());
        RlpList topicList = (RlpList)list.get(2);
        for (RlpElement element : topicList) {
            this.topics.add(ByteUtils.byteArrayToString((byte[])element.getRlpData()));
        }
        this.logData = ((RlpElement)list.get(3)).getRlpData();
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("from", (Object)ByteUtils.toHexString((byte[])this.from.getValue()));
        jsonObject.put("to", (Object)ByteUtils.toHexString((byte[])this.to.getValue()));
        jsonObject.put("log_data", (Object)ByteUtils.toHexString((byte[])this.logData));
        JSONArray jsonArray = new JSONArray();
        if (this.topics != null) {
            jsonArray.addAll(this.topics);
        }
        jsonObject.put("topics", (Object)jsonArray);
        return jsonObject;
    }

    @Override
    public LogModel fromJson(JSONObject jsonObject) {
        this.from = new Identity(jsonObject.getString("from"));
        this.to = new Identity(jsonObject.getString("to"));
        this.logData = ByteUtils.hexStringToBytes((String)jsonObject.getString("log_data"));
        JSONArray jsonArray = jsonObject.getJSONArray("topics");
        if (jsonArray != null) {
            for (Object o : jsonArray) {
                this.topics.add((String)o);
            }
        }
        return this;
    }

    public String toString() {
        return "LogModel{from=" + (this.from == null ? null : this.from.hexStrValue()) + ", to=" + (this.to == null ? null : this.to.hexStrValue()) + ", topics=" + this.topics + ", logData=" + (this.logData == null ? null : Hex.toHexString((byte[])this.logData)) + '}';
    }
}

