/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.receipt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.chainstack.jbcc.mychainx.model.IMychainObject;
import com.alipay.chainstack.jbcc.mychainx.model.log.LogModel;
import com.alipay.chainstack.jbcc.mychainx.util.SubnetIdUtils;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class ReceiptModel
implements IMychainObject<ReceiptModel> {
    protected long result = 1L;
    protected BigInteger gasUsed;
    protected List<LogModel> logs = new ArrayList<LogModel>();
    protected byte[] output;
    protected Hash txHash = new Hash();
    protected BigInteger blockNumber = BigInteger.ZERO;
    protected BaseFixedSizeByteArray.Fixed20ByteArray groupId;
    protected int txIndex = 0;

    public long getResult() {
        return this.result;
    }

    public ReceiptModel setResult(long result) {
        this.result = result;
        return this;
    }

    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    public ReceiptModel setGasUsed(BigInteger gasUsed) {
        this.gasUsed = gasUsed;
        return this;
    }

    public List<LogModel> getLogs() {
        return this.logs;
    }

    public ReceiptModel setLogs(List<LogModel> logs) {
        this.logs = logs;
        return this;
    }

    public BaseFixedSizeByteArray.Fixed20ByteArray getGroupId() {
        return this.groupId;
    }

    public ReceiptModel setGroupId(BaseFixedSizeByteArray.Fixed20ByteArray groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getSubnetId() {
        return SubnetIdUtils.getSubnetIdByChainId(this.groupId);
    }

    public byte[] getOutput() {
        return this.output;
    }

    public ReceiptModel setOutput(byte[] output) {
        this.output = output;
        return this;
    }

    public Hash getTxHash() {
        return this.txHash;
    }

    public ReceiptModel setTxHash(Hash txHash) {
        this.txHash = txHash;
        return this;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public ReceiptModel setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
        return this;
    }

    public int getTxIndex() {
        return this.txIndex;
    }

    public ReceiptModel setTxIndex(int txIndex) {
        this.txIndex = txIndex;
        return this;
    }

    @Override
    public byte[] toRlp() {
        byte[] resultBytes = Rlp.encodeBigInteger((BigInteger)BigInteger.valueOf(this.result));
        byte[] gasUsedBytes = Rlp.encodeBigInteger((BigInteger)this.gasUsed);
        ArrayList<byte[]> logList = new ArrayList<byte[]>();
        if (this.logs != null) {
            for (LogModel item : this.logs) {
                logList.add(item.toRlp());
            }
        }
        byte[] logsBytes = Rlp.encodeList(logList);
        byte[] outputBytes = Rlp.encodeElement((byte[])this.output);
        return Rlp.encodeList((byte[][])new byte[][]{resultBytes, gasUsedBytes, logsBytes, outputBytes});
    }

    public long getSize() {
        return this.toRlp().length;
    }

    @Override
    public ReceiptModel fromRlp(RlpList list) {
        this.result = ByteUtils.byteArrayToLong((byte[])((RlpElement)list.get(0)).getRlpData());
        this.gasUsed = ByteUtils.byteArrayToBigInteger((byte[])((RlpElement)list.get(1)).getRlpData());
        RlpList logList = (RlpList)list.get(2);
        for (RlpElement element : logList) {
            LogModel item = new LogModel();
            item.fromRlp((RlpList)element);
            this.logs.add(item);
        }
        this.output = ((RlpElement)list.get(3)).getRlpData();
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", (Object)this.result);
        jsonObject.put("gas_used", (Object)this.gasUsed);
        jsonObject.put("output", (Object)ByteUtils.toHexString((byte[])this.output));
        JSONArray logsArray = new JSONArray();
        if (this.logs != null) {
            for (LogModel item : this.logs) {
                JSONObject object = item.toJson();
                logsArray.add((Object)object);
            }
        }
        jsonObject.put("logs", (Object)logsArray);
        return jsonObject;
    }

    @Override
    public ReceiptModel fromJson(JSONObject jsonObject) {
        this.result = jsonObject.getLong("result");
        this.gasUsed = jsonObject.getBigInteger("gas_used");
        this.output = ByteUtils.hexStringToBytes((String)jsonObject.getString("output"));
        JSONArray extArray = jsonObject.getJSONArray("logs");
        if (extArray != null) {
            for (Object o : extArray) {
                LogModel object = new LogModel();
                object.fromJson((JSONObject)o);
                this.logs.add(object);
            }
        }
        return this;
    }

    public String toString() {
        return "ReceiptModel{result=" + this.result + ", gasUsed=" + this.gasUsed + ", blockNumber=" + this.blockNumber + ", txHash=" + (this.txHash == null ? null : this.txHash.hexStrValue()) + ", logs=" + this.logs + ", output=" + (this.output == null ? "null" : Hex.toHexString((byte[])this.output)) + '}';
    }
}

