/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.request;

import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.exception.RichClientException;
import com.alipay.chainstack.jbcc.mychainx.exception.error.ErrorCode;
import com.alipay.chainstack.jbcc.mychainx.model.account.AccountModel;
import com.alipay.chainstack.jbcc.mychainx.model.account.AccountStatus;
import com.alipay.chainstack.jbcc.mychainx.model.account.AuthMap;
import com.alipay.chainstack.jbcc.mychainx.model.account.NamedIdentity;
import com.alipay.chainstack.jbcc.mychainx.model.request.BaseTxRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionType;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import java.util.Map;

public class AccountCreateRequestModel
extends BaseTxRequestModel {
    private Map<Keypair, Integer> authKeys;
    private Keypair recoverKey;
    private byte[] encryptionKey;
    private String accountName;

    public AccountCreateRequestModel() {
    }

    public AccountCreateRequestModel(NamedIdentity operator, String accountName, Map<Keypair, Integer> authKeys, Keypair recoverKey, byte[] encryptionKey) {
        this.from = operator;
        this.to = new NamedIdentity(accountName);
        this.accountName = accountName;
        this.authKeys = authKeys;
        this.recoverKey = recoverKey;
        this.encryptionKey = encryptionKey;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public AccountCreateRequestModel setAccountName(String accountName) {
        this.accountName = accountName;
        if (!StringUtils.isEmpty((String)accountName)) {
            this.to = new NamedIdentity(accountName);
        }
        return this;
    }

    public Map<Keypair, Integer> getAuthKeys() {
        return this.authKeys;
    }

    public AccountCreateRequestModel setAuthKeys(Map<Keypair, Integer> authKeys) {
        this.authKeys = authKeys;
        return this;
    }

    public Keypair getRecoverKey() {
        return this.recoverKey;
    }

    public AccountCreateRequestModel setRecoverKey(Keypair recoverKey) {
        this.recoverKey = recoverKey;
        return this;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public AccountCreateRequestModel setEncryptionKey(byte[] encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    @Override
    public TransactionModel buildRawTx() {
        TransactionModel transaction = super.buildRawTx();
        NamedIdentity accountId = (NamedIdentity)this.to;
        AccountModel accountModel = new AccountModel();
        accountModel.setIdentity(accountId);
        accountModel.setStatus(AccountStatus.NORMAL);
        AuthMap authMap = new AuthMap();
        if (null == this.authKeys || this.authKeys.isEmpty()) {
            throw new RichClientException(ErrorCode.ACCOUNT_KEY_EMPTY_INVALID);
        }
        for (Map.Entry<Keypair, Integer> entry : this.authKeys.entrySet()) {
            authMap.updateAuth(new PublicKey(entry.getKey().getPubkeyEncoded()), entry.getValue());
        }
        accountModel.setAuthMap(authMap);
        if (this.recoverKey == null) {
            throw new RichClientException(ErrorCode.ACCOUNT_KEY_EMPTY_INVALID);
        }
        accountModel.setRecoverKey(new PublicKey(this.recoverKey));
        accountModel.setEncryptionKey(this.encryptionKey);
        transaction.setTxType(TransactionType.TX_CREATE_ACCOUNT);
        transaction.setData(accountModel.toRlp());
        transaction.complete(this.getSigner());
        return transaction;
    }
}

