/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.request;

import com.alipay.chainstack.commons.jbcc.commons.model.TraceableTxObject;
import com.alipay.chainstack.commons.jbcc.commons.model.TraceableTxRequest;
import com.alipay.chainstack.commons.jbcc.commons.utils.TraceUtil;
import com.alipay.chainstack.commons.jbcc.commons.utils.VOUtils;
import com.alipay.chainstack.commons.utils.ReflectionUtil;
import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.model.request.ConfidentialRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractCallRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.RequestContext;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionType;
import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.vm.WASMOutput;
import io.opentracing.Span;
import java.util.List;

public abstract class BaseBAORequest {
    private RequestContext reqContext = new RequestContext();

    public abstract Parameters getParameters();

    public RequestContext getReqContext() {
        return this.reqContext;
    }

    public void setReqContext(RequestContext reqContext) {
        this.reqContext = reqContext;
    }

    public TransactionModel buildTransaction(boolean isLocal) {
        ContractCallRequestModel callRequest = (ContractCallRequestModel)new ContractCallRequestModel().setParameters(this.getParameters()).setVmType(this.reqContext.getContract().getVmType()).setValue(this.reqContext.getValue()).setFrom(this.reqContext.getAccount()).setTo(this.reqContext.getContract().getId()).setGas(this.reqContext.getGas()).setSigner(this.reqContext.getSigner()).setSubnetId(this.reqContext.getSubnetId()).setLocalCall(isLocal).setBlockNumber(this.reqContext.getBlockNumber());
        TransactionModel tx = this.buildTxWithTraceInfo(callRequest);
        this.reqContext.setTransaction(tx);
        return tx;
    }

    public TransactionModel buildConfidentialTransaction(boolean isLocal, String encryptionKey, List<byte[]> envelopeSealKeys) {
        if (StringUtils.isEmpty((String)encryptionKey)) {
            throw new RuntimeException("encryption key is empty");
        }
        ContractCallRequestModel request = (ContractCallRequestModel)new ContractCallRequestModel().setParameters(this.getParameters()).setVmType(this.reqContext.getContract().getVmType()).setValue(this.reqContext.getValue()).setFrom(this.reqContext.getAccount()).setTo(this.reqContext.getContract().getId()).setSigner(this.reqContext.getSigner()).setLocalCall(isLocal).setBlockNumber(this.reqContext.getBlockNumber()).setGas(this.reqContext.getGas());
        this.buildTxWithTraceInfo(request);
        ConfidentialRequestModel confidentialRequest = new ConfidentialRequestModel(request, encryptionKey);
        confidentialRequest.setEnvelopeSealKeys(envelopeSealKeys);
        TransactionModel tx = confidentialRequest.getTxObject();
        this.reqContext.setTransaction(tx);
        return tx;
    }

    public Object getParamByPath(String path) {
        return ReflectionUtil.getFieldByPath((String)path, (Object)this);
    }

    public void checkVersion(Object vo) {
        VOUtils.checkRequestVersion((Object)vo, (Integer)this.reqContext.getVersion());
    }

    public BaseBAORequest fromRequestVO(Object requestVO) {
        return null;
    }

    protected TransactionModel buildTxWithTraceInfo(ContractCallRequestModel callRequest) {
        if (!TraceUtil.isTraceEnabled()) {
            return callRequest.getTxObject();
        }
        TraceUtil.injectTxTraceContext((TraceableTxRequest)callRequest);
        TransactionModel tx = callRequest.getTxObject();
        Span span = TraceUtil.setupSpan((TraceableTxObject)tx, (String)this.reqContext.getContract().getClient().getClass().getSimpleName());
        TraceUtil.addTraceToTxRuntime((Span)span, (TraceableTxObject)tx);
        return tx;
    }

    protected static String getTransactionMethod(TransactionModel transactionModel, WASMOutput output) {
        if (transactionModel.getTxType() != TransactionType.TX_CALL_CONTRACT) {
            return null;
        }
        try {
            return output.getString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

