/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.request;

import com.alipay.chainstack.commons.jbcc.commons.model.TraceableTxRequest;
import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.domain.account.AccountManager;
import com.alipay.chainstack.jbcc.mychainx.domain.account.Signer;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.Extension;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.util.SubnetIdUtils;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseTxRequestModel
extends TraceableTxRequest {
    protected boolean localCall = false;
    protected Identity from;
    protected Identity to;
    protected BigInteger blockNumber;
    protected BigInteger value = BigInteger.ZERO;
    protected BigInteger gas = BigInteger.ZERO;
    protected Map<String, Object> extendedParams = new HashMap<String, Object>();
    protected List<Extension> extensions = new ArrayList<Extension>();
    protected Signer signer;
    protected String subnetId;
    protected volatile TransactionModel transactionModel;

    public TransactionModel buildRawTx() {
        return this.buildRawTxInternal();
    }

    protected final TransactionModel buildRawTxInternal() {
        long ts = System.currentTimeMillis();
        TransactionModel transaction = new TransactionModel();
        transaction.setExtensions(this.extensions);
        transaction.setBlockNumber(this.blockNumber);
        transaction.setFrom(this.from);
        transaction.setTo(this.to);
        transaction.setTimestamp(ts);
        transaction.setNonce(ts);
        transaction.setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf((BigInteger)this.value));
        if (!StringUtils.isEmpty((String)this.subnetId)) {
            transaction.setGroupId(SubnetIdUtils.getChainIdBytesBySubnetId(this.subnetId));
        }
        if (!this.traceInfo.isEmpty()) {
            transaction.getExtensions().add(new Extension(536300, this.getTraceContent()));
        }
        return transaction;
    }

    public Map<String, Object> getExtendedParams() {
        return this.extendedParams;
    }

    public BaseTxRequestModel setExtendedParams(Map<String, Object> extendedParams) {
        this.extendedParams = extendedParams;
        return this;
    }

    public Identity getFrom() {
        return this.from;
    }

    public BaseTxRequestModel setFrom(Identity from) {
        this.from = from;
        return this;
    }

    public Identity getTo() {
        return this.to;
    }

    public BaseTxRequestModel setTo(Identity to) {
        this.to = to;
        return this;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BaseTxRequestModel setValue(BigInteger value) {
        this.value = value;
        return this;
    }

    public BigInteger getGas() {
        return this.gas;
    }

    public BaseTxRequestModel setGas(BigInteger gas) {
        this.gas = gas;
        return this;
    }

    public Signer getSigner() {
        return this.signer == null ? (AccountManager.getInstance().hasAccount(this.from) ? AccountManager.getInstance().getAccountByIdentity(this.from).getSigner() : null) : this.signer;
    }

    public BaseTxRequestModel setSigner(Signer signer) {
        this.signer = signer;
        return this;
    }

    public TransactionModel getTxObject() {
        if (this.transactionModel == null) {
            this.transactionModel = this.buildRawTx();
        }
        return this.transactionModel;
    }

    public BaseTxRequestModel setTransactionModel(TransactionModel transactionModel) {
        this.transactionModel = transactionModel;
        return this;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public BaseTxRequestModel setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
        return this;
    }

    public boolean isLocalCall() {
        return this.localCall;
    }

    public BaseTxRequestModel setLocalCall(boolean localCall) {
        this.localCall = localCall;
        return this;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public BaseTxRequestModel setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public BaseTxRequestModel setSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public boolean isCompleted() {
        return this.transactionModel != null;
    }
}

