/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.request;

import com.alipay.chainstack.jbcc.mychainx.model.request.BaseTxRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractCallRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractDeployRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.request.ContractUpdateRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.util.ConfidentialUtil;
import java.util.List;

public class ConfidentialRequestModel
extends BaseTxRequestModel {
    protected TransactionModel requestTransaction;
    protected BaseTxRequestModel request;
    private List<byte[]> envelopeSealKeys;
    protected byte[] transactionKey;

    public ConfidentialRequestModel() {
    }

    public ConfidentialRequestModel(BaseTxRequestModel request, String rootKey) {
        if (!this.isValid(request)) {
            throw new RuntimeException("confidential request only supports deploy/update/call contract request");
        }
        this.localCall = request.localCall;
        this.request = request;
        this.requestTransaction = request.getTxObject();
        this.transactionKey = com.alipay.mychain.sdk.api.utils.ConfidentialUtil.keyGenerate((String)rootKey, (byte[])this.requestTransaction.getHash().getData());
    }

    public List<byte[]> getEnvelopeSealKeys() {
        return this.envelopeSealKeys;
    }

    public ConfidentialRequestModel setEnvelopeSealKeys(List<byte[]> envelopeSealKeys) {
        this.envelopeSealKeys = envelopeSealKeys;
        return this;
    }

    public BaseTxRequestModel getRequest() {
        return this.request;
    }

    public TransactionModel getRequestTransaction() {
        return this.requestTransaction;
    }

    public byte[] getTransactionKey() {
        return this.transactionKey;
    }

    protected boolean isValid(BaseTxRequestModel request) {
        return request instanceof ContractCallRequestModel || request instanceof ContractDeployRequestModel || request instanceof ContractUpdateRequestModel;
    }

    @Override
    public TransactionModel buildRawTx() {
        return ConfidentialUtil.encrypt(this.requestTransaction, this.transactionKey, this.envelopeSealKeys);
    }

    public TransactionModel buildRawTx(List<byte[]> envelopeSealKeys) {
        return ConfidentialUtil.encrypt(this.requestTransaction, this.transactionKey, envelopeSealKeys);
    }
}

