/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.request;

import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.model.request.BaseTxRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionType;
import com.alipay.chainstack.jbcc.mychainx.util.ContractParameterUtil;
import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import java.math.BigInteger;

public class ContractCallRequestModel
extends BaseTxRequestModel {
    private String methodSignature;
    private Parameters parameters;
    private VMTypeEnum vmType = VMTypeEnum.WASM;

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public ContractCallRequestModel setMethodSignature(String methodSignature) {
        this.methodSignature = methodSignature;
        return this;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public ContractCallRequestModel setParameters(Parameters parameters) {
        this.parameters = parameters;
        if (StringUtils.isEmpty((String)this.methodSignature) && parameters != null) {
            this.methodSignature = ContractParameterUtil.getMethodSignature(parameters);
        }
        return this;
    }

    public VMTypeEnum getVmType() {
        return this.vmType;
    }

    public ContractCallRequestModel setVmType(VMTypeEnum vmType) {
        this.vmType = vmType;
        return this;
    }

    @Override
    public TransactionModel buildRawTx() {
        TransactionModel transaction = super.buildRawTx();
        transaction.setTxType(TransactionType.TX_CALL_CONTRACT);
        transaction.setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf((BigInteger)this.value));
        transaction.setData(this.parameters.getData());
        transaction.complete(this.getSigner());
        return transaction;
    }
}

