/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.request;

import com.alipay.chainstack.commons.utils.StringUtils;
import com.alipay.chainstack.jbcc.mychainx.model.request.BaseTxRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionType;
import com.alipay.chainstack.jbcc.mychainx.util.ContractParameterUtil;
import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.utils.VMUtils;

public class ContractDeployRequestModel
extends BaseTxRequestModel {
    protected byte[] code;
    protected String methodSignature;
    protected Parameters parameters;
    protected VMTypeEnum vmType;

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public ContractDeployRequestModel setMethodSignature(String methodSignature) {
        this.methodSignature = methodSignature;
        return this;
    }

    public VMTypeEnum getVmType() {
        return this.vmType;
    }

    public ContractDeployRequestModel setVmType(VMTypeEnum vmType) {
        this.vmType = vmType;
        return this;
    }

    public byte[] getCode() {
        return this.code;
    }

    public ContractDeployRequestModel setCode(byte[] code) {
        this.code = code;
        return this;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public ContractDeployRequestModel setParameters(Parameters parameters) {
        this.parameters = parameters;
        if (StringUtils.isEmpty((String)this.methodSignature) && parameters != null) {
            this.methodSignature = ContractParameterUtil.getMethodSignature(parameters);
        }
        return this;
    }

    @Override
    public TransactionModel buildRawTx() {
        TransactionModel transaction = super.buildRawTx();
        transaction.setTxType(TransactionType.TX_DEPLOY_CONTRACT);
        byte[] pa = null;
        if (this.parameters != null) {
            pa = this.parameters.getData();
        }
        transaction.setData(VMUtils.constructDeployData((VMTypeEnum)this.vmType, (byte[])this.code, (byte[])pa));
        transaction.complete(this.getSigner());
        return transaction;
    }
}

