/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.request;

import com.alipay.chainstack.jbcc.mychainx.domain.account.Signer;
import com.alipay.chainstack.jbcc.mychainx.model.acl.ContractACL;
import com.alipay.chainstack.jbcc.mychainx.model.request.BaseTxRequestModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionType;
import com.alipay.mychain.sdk.vm.WASMParameter;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes32;
import com.alipay.mychain.sdk.vm.abi.datatype.Pair;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint8;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class DataContractSetACLRequestModel
extends BaseTxRequestModel {
    private List<ContractACL> contractACLList;

    public DataContractSetACLRequestModel() {
    }

    public DataContractSetACLRequestModel(List<ContractACL> contractACLList) {
        this.contractACLList = contractACLList;
    }

    public List<ContractACL> getContractACLList() {
        return this.contractACLList;
    }

    public DataContractSetACLRequestModel setContractACLList(List<ContractACL> contractACLList) {
        this.contractACLList = contractACLList;
        return this;
    }

    @Override
    public TransactionModel buildRawTx() {
        Signer signer = this.getSigner();
        TransactionModel transaction = super.buildRawTx();
        transaction.setTxType(TransactionType.TX_SET_CONTRACT_ACL);
        ArrayList<Pair> aclPairs = new ArrayList<Pair>();
        for (ContractACL contractACL : this.contractACLList) {
            Pair aclTuple = new Pair((Type)new Bytes32(contractACL.getContract().getValue()), (Type)new Uint8(contractACL.toAccessControl().getAcl()));
            aclPairs.add(aclTuple);
        }
        WASMParameter wasmParameter = new WASMParameter();
        wasmParameter.setMethodSignature("SetAcl");
        wasmParameter.addUInt32(BigInteger.ZERO);
        wasmParameter.addPairArray(aclPairs);
        transaction.setData(wasmParameter.getData());
        transaction.setFrom(this.to);
        transaction.complete(signer);
        return transaction;
    }
}

