/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.request;

import com.alipay.chainstack.jbcc.mychainx.domain.account.Account;
import com.alipay.chainstack.jbcc.mychainx.domain.account.Signer;
import com.alipay.chainstack.jbcc.mychainx.domain.contract.Contract;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.chainstack.jbcc.mychainx.model.account.NamedIdentity;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionModel;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import java.math.BigInteger;
import org.bouncycastle.util.encoders.Hex;

public class RequestContext {
    protected String accountNameHex;
    protected BigInteger value = BigInteger.ZERO;
    protected BigInteger gas = BigInteger.ZERO;
    protected Hash txHash;
    protected Identity account;
    protected String contractName;
    protected String contractNameHex;
    protected Contract contract;
    protected String methodSig;
    protected BigInteger blockNumber;
    protected Signer signer;
    protected int txIndex;
    protected boolean localCall;
    protected String subnetId;
    protected Integer version;
    protected TransactionModel transaction;

    public TransactionModel getTransaction() {
        return this.transaction;
    }

    public RequestContext setTransaction(TransactionModel transaction) {
        this.transaction = transaction;
        return this;
    }

    public boolean isLocalCall() {
        return this.localCall;
    }

    public RequestContext setLocalCall(boolean localCall) {
        this.localCall = localCall;
        return this;
    }

    public String getAccountName() {
        if (this.account instanceof NamedIdentity) {
            return ((NamedIdentity)this.account).getName();
        }
        return null;
    }

    public void setAccountName(String accountName) {
        if (accountName != null) {
            this.account = new NamedIdentity(accountName);
            this.accountNameHex = Hex.toHexString((byte[])this.account.getData());
        }
    }

    public String getAccountNameHex() {
        return this.accountNameHex;
    }

    public void setAccountNameHex(String accountNameHex) {
        this.accountNameHex = accountNameHex;
        if (accountNameHex != null) {
            this.account = new Identity(accountNameHex);
        }
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public Hash getTxHash() {
        return this.txHash;
    }

    public void setTxHash(Hash txHash) {
        this.txHash = txHash;
    }

    public Identity getAccount() {
        return this.account;
    }

    public void setAccount(Identity account) {
        this.account = account;
    }

    public void setAccount(Account account) {
        this.account = account.getId();
        this.signer = account.getSigner();
    }

    public String getContractName() {
        return this.contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractNameHex() {
        return this.contractNameHex;
    }

    public void setContractNameHex(String contractNameHex) {
        this.contractNameHex = contractNameHex;
    }

    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
        if (contract != null) {
            this.contractName = contract.getName();
            this.contractNameHex = contract.getId().hexStrValue();
        }
    }

    public String getMethodSig() {
        return this.methodSig;
    }

    public void setMethodSig(String methodSig) {
        this.methodSig = methodSig;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public BigInteger getGas() {
        return this.gas;
    }

    public void setGas(BigInteger gas) {
        this.gas = gas;
    }

    public Signer getSigner() {
        return this.signer;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }

    public int getTxIndex() {
        return this.txIndex;
    }

    public void setTxIndex(int txIndex) {
        this.txIndex = txIndex;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String toString() {
        return "RequestContext{accountNameHex='" + this.accountNameHex + '\'' + ", value=" + this.value + ", version=" + this.version + ", gas=" + this.gas + ", txHash=" + this.txHash + ", subnetId=" + this.subnetId + ", account=" + (Object)((Object)this.account) + ", contractName='" + this.contractName + '\'' + ", contractNameHex='" + this.contractNameHex + '\'' + ", contract=" + this.contract + ", methodSig='" + this.methodSig + '\'' + ", blockNumber=" + this.blockNumber + ", signer=" + this.signer + ", txIndex=" + this.txIndex + '}';
    }
}

