/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.response;

import com.alipay.chainstack.commons.utils.ByteUtils;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.chainstack.jbcc.mychainx.model.acl.ContractACL;
import com.alipay.chainstack.jbcc.mychainx.model.receipt.ReceiptModel;
import com.alipay.mychain.sdk.vm.WASMOutput;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint8;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class DataContractGetACLResponseModel {
    private List<ContractACL> contractACLs;

    public DataContractGetACLResponseModel(ReceiptModel receiptModel, List<Identity> identities) {
        byte[] rawOutput = receiptModel.getOutput();
        if (receiptModel.getResult() != 0L || ByteUtils.isEmpty((byte[])rawOutput)) {
            return;
        }
        WASMOutput output = new WASMOutput(Hex.toHexString((byte[])rawOutput));
        List aclBytes = output.getIntAndUintDynamicArray(Uint8.class);
        if (aclBytes == null) {
            return;
        }
        if (identities == null || identities.size() != aclBytes.size()) {
            return;
        }
        this.contractACLs = new ArrayList<ContractACL>();
        for (int i = 0; i < aclBytes.size(); ++i) {
            ContractACL contractAccessControl = ContractACL.fromACLByte(((BigInteger)aclBytes.get(i)).byteValue());
            contractAccessControl.setContract(identities.get(i));
            this.contractACLs.add(contractAccessControl);
        }
    }

    public List<ContractACL> getContractACLs() {
        return this.contractACLs;
    }
}

