/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.transaction;

import com.alibaba.fastjson.JSONObject;
import com.alipay.chainstack.jbcc.mychainx.model.IMychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class Extension
implements IMychainObject<Extension> {
    private int key;
    private byte[] value;

    public Extension(int key, byte[] value) {
        this.key = key;
        this.value = value;
    }

    public Extension() {
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public byte[] toRlp() {
        byte[] keyBytes = Rlp.encodeInt((int)this.key);
        byte[] valueBytes = Rlp.encodeElement((byte[])this.value);
        return Rlp.encodeList((byte[][])new byte[][]{keyBytes, valueBytes});
    }

    @Override
    public Extension fromRlp(RlpList list) {
        this.key = ByteUtils.byteArrayToInt((byte[])((RlpElement)list.get(0)).getRlpData());
        this.value = ((RlpElement)list.get(1)).getRlpData();
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)this.key);
        jsonObject.put("value", (Object)ByteUtils.toHexString((byte[])this.value));
        return jsonObject;
    }

    @Override
    public Extension fromJson(JSONObject jsonObject) {
        this.key = jsonObject.getIntValue("key");
        this.value = ByteUtils.hexStringToBytes((String)jsonObject.getString("value"));
        return this;
    }
}

