/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.chainstack.jbcc.mychainx.model.transaction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.chainstack.commons.jbcc.commons.model.TraceableTxObject;
import com.alipay.chainstack.commons.utils.JsonUtils;
import com.alipay.chainstack.jbcc.mychainx.domain.account.Signer;
import com.alipay.chainstack.jbcc.mychainx.model.IMychainObject;
import com.alipay.chainstack.jbcc.mychainx.model.account.Identity;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.Extension;
import com.alipay.chainstack.jbcc.mychainx.model.transaction.TransactionType;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import com.alipay.mychain.sdk.utils.ByteUtils;
import com.alipay.mychain.sdk.utils.RandomUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;

public class TransactionModel
extends TraceableTxObject
implements IMychainObject<TransactionModel> {
    private TransactionType txType = TransactionType.TX_UNKNOWN;
    private byte[] data = null;
    private List<byte[]> signatureList = new ArrayList<byte[]>();
    private Hash hash = new Hash();
    private Identity from = new Identity();
    private Identity to = new Identity();
    private long timestamp = 0L;
    private long period = 0L;
    private BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger nonce = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.ZERO;
    private BigInteger gas = BigInteger.ZERO;
    private BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger value = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.ZERO;
    private List<Extension> extensions = new ArrayList<Extension>();
    private BaseFixedSizeByteArray.Fixed20ByteArray groupId = BaseFixedSizeByteArray.Fixed20ByteArray.defaultValue();
    private short version = (short)2;
    private BigInteger blockNumber = BigInteger.ZERO;
    private int txIndex = 0;
    private final Map<String, Object> runtimeContext = new HashMap<String, Object>();
    private AtomicReference<byte[]> txBytesCache = new AtomicReference<Object>(null);

    public TransactionType getTxType() {
        return this.txType;
    }

    public TransactionModel setTxType(TransactionType txType) {
        this.txType = txType;
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public TransactionModel setData(byte[] data) {
        this.data = data;
        return this;
    }

    public List<byte[]> getSignatureList() {
        return this.signatureList;
    }

    public TransactionModel setSignatureList(List<byte[]> signatureList) {
        this.signatureList = signatureList;
        return this;
    }

    public Hash getHash() {
        return this.hash;
    }

    public TransactionModel setHash(Hash hash) {
        this.hash = hash;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TransactionModel setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Identity getFrom() {
        return this.from;
    }

    public TransactionModel setFrom(Identity from) {
        this.from = from;
        return this;
    }

    public Identity getTo() {
        return this.to;
    }

    public TransactionModel setTo(Identity to) {
        this.to = to;
        return this;
    }

    public long getPeriod() {
        return this.period;
    }

    public TransactionModel setPeriod(long period) {
        this.period = period;
        return this;
    }

    public BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger getNonce() {
        return this.nonce;
    }

    public TransactionModel setNonce(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger nonce) {
        this.nonce = nonce;
        return this;
    }

    public TransactionModel setNonce(long timestamp) {
        this.nonce = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf((long)RandomUtil.randomize((long)(timestamp + (long)this.hashCode() + System.nanoTime())));
        return this;
    }

    public Map<String, String> getTraceInfo() {
        Extension traceExt;
        Extension extension = traceExt = this.extensions == null ? null : (Extension)this.extensions.stream().filter(e -> e.getKey() == 536300).findFirst().orElse(null);
        if (traceExt == null) {
            return null;
        }
        HashMap<String, String> traceInfo = new HashMap<String, String>();
        JSONObject jsonObject = JsonUtils.parseObject((String)new String(traceExt.getValue(), StandardCharsets.UTF_8));
        for (String key : jsonObject.keySet()) {
            traceInfo.put(key, jsonObject.getString(key));
        }
        return traceInfo;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public TransactionModel setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public BigInteger getGas() {
        return this.gas;
    }

    public TransactionModel setGas(BigInteger gas) {
        this.gas = gas;
        return this;
    }

    public BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger getValue() {
        return this.value;
    }

    public TransactionModel setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger value) {
        this.value = value;
        return this;
    }

    public BaseFixedSizeByteArray.Fixed20ByteArray getGroupId() {
        return this.groupId;
    }

    public TransactionModel setGroupId(BaseFixedSizeByteArray.Fixed20ByteArray groupId) {
        this.groupId = groupId;
        return this;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public TransactionModel setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
        return this;
    }

    public int getTxIndex() {
        return this.txIndex;
    }

    public TransactionModel setTxIndex(int txIndex) {
        this.txIndex = txIndex;
        return this;
    }

    public short getVersion() {
        return this.version;
    }

    public TransactionModel setVersion(short version) {
        this.version = version;
        return this;
    }

    public String getTxObjectHash() {
        return this.hash.hexStrValue();
    }

    public long getPayloadSize() {
        return this.data.length;
    }

    public String getTxObjectType() {
        return this.txType.name();
    }

    public void complete(Signer signer) {
        if (this.getHash() != null && !this.getSignatureList().isEmpty()) {
            return;
        }
        if (signer == null) {
            throw new RuntimeException(String.format("unable to find signer for account %s", this.from.hexStrValue()));
        }
        this.setHash(new Hash(HashFactory.getHash().hash(this.buildData())));
        this.setSignatureList(signer.sign(this.getHash().getData()));
    }

    public byte[] buildData() {
        byte[] txRawBytes = this.txBytesCache.get();
        if (txRawBytes != null) {
            return txRawBytes;
        }
        ArrayList<byte[]> dataRlp = new ArrayList<byte[]>();
        byte[] txType = Rlp.encodeInt((int)this.getTxType().getValue());
        byte[] timestamp = Rlp.encodeBigInteger((BigInteger)BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf((long)this.getTimestamp()).getValue());
        byte[] nonce = Rlp.encodeBigInteger((BigInteger)this.getNonce().getValue());
        byte[] period = Rlp.encodeBigInteger((BigInteger)BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf((long)this.getPeriod()).getValue());
        byte[] from = Rlp.encodeElement((byte[])this.getFrom().getValue());
        byte[] to = Rlp.encodeElement((byte[])this.getTo().getValue());
        byte[] value = Rlp.encodeBigInteger((BigInteger)this.getValue().getValue());
        byte[] gas = Rlp.encodeBigInteger((BigInteger)this.getGas());
        byte[] groupId = Rlp.encodeElement((byte[])this.getGroupId().getData());
        byte[] data = Rlp.encodeElement((byte[])this.getData());
        ArrayList<byte[]> extList = new ArrayList<byte[]>();
        if (this.extensions != null) {
            for (Extension item : this.extensions) {
                extList.add(item.toRlp());
            }
        }
        byte[] extensionsBytes = Rlp.encodeList(extList);
        dataRlp.add(txType);
        dataRlp.add(timestamp);
        dataRlp.add(nonce);
        dataRlp.add(period);
        dataRlp.add(from);
        dataRlp.add(to);
        dataRlp.add(value);
        dataRlp.add(gas);
        dataRlp.add(groupId);
        dataRlp.add(Rlp.encodeInt((int)this.version));
        dataRlp.add(data);
        dataRlp.add(extensionsBytes);
        txRawBytes = Rlp.encodeList(dataRlp);
        this.txBytesCache.compareAndSet(null, txRawBytes);
        return this.txBytesCache.get();
    }

    @Override
    public byte[] toRlp() {
        byte[] hashBytes = Rlp.encodeElement((byte[])this.hash.getValue());
        byte[] txTypeBytes = Rlp.encodeInt((int)this.txType.getValue());
        byte[] timestampBytes = Rlp.encodeLong((long)this.timestamp);
        byte[] nonceBytes = Rlp.encodeBigInteger((BigInteger)this.nonce.getValue());
        byte[] periodBytes = Rlp.encodeLong((long)this.period);
        byte[] fromBytes = Rlp.encodeElement((byte[])this.from.getValue());
        byte[] toBytes = Rlp.encodeElement((byte[])this.to.getValue());
        byte[] valueBytes = Rlp.encodeBigInteger((BigInteger)this.value.getValue());
        byte[] gasBytes = Rlp.encodeBigInteger((BigInteger)this.gas);
        byte[] groupIdBytes = Rlp.encodeElement((byte[])this.groupId.getData());
        byte[] versionBytes = Rlp.encodeShort((short)this.version);
        byte[] dataBytes = Rlp.encodeElement((byte[])this.data);
        ArrayList<byte[]> sigList = new ArrayList<byte[]>();
        if (this.signatureList != null) {
            for (byte[] item : this.signatureList) {
                sigList.add(Rlp.encodeElement((byte[])item));
            }
        }
        byte[] signatureBytes = Rlp.encodeList(sigList);
        ArrayList<byte[]> extList = new ArrayList<byte[]>();
        if (this.extensions != null) {
            for (Extension item : this.extensions) {
                extList.add(item.toRlp());
            }
        }
        byte[] extensionsBytes = Rlp.encodeList(extList);
        return Rlp.encodeList((byte[][])new byte[][]{hashBytes, txTypeBytes, timestampBytes, nonceBytes, periodBytes, fromBytes, toBytes, valueBytes, gasBytes, groupIdBytes, versionBytes, dataBytes, signatureBytes, extensionsBytes});
    }

    @Override
    public TransactionModel fromRlp(RlpList list) {
        this.hash = new Hash(((RlpElement)list.get(0)).getRlpData());
        this.txType = TransactionType.forNumber(ByteUtils.byteArrayToInt((byte[])((RlpElement)list.get(1)).getRlpData()));
        this.timestamp = ByteUtils.byteArrayToLong((byte[])((RlpElement)list.get(2)).getRlpData());
        this.nonce = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf((BigInteger)ByteUtils.byteArrayToBigInteger((byte[])((RlpElement)list.get(3)).getRlpData()));
        this.period = ByteUtils.byteArrayToLong((byte[])((RlpElement)list.get(4)).getRlpData());
        this.from = new Identity(((RlpElement)list.get(5)).getRlpData());
        this.to = new Identity(((RlpElement)list.get(6)).getRlpData());
        this.value = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf((BigInteger)ByteUtils.byteArrayToBigInteger((byte[])((RlpElement)list.get(7)).getRlpData()));
        this.gas = ByteUtils.byteArrayToBigInteger((byte[])((RlpElement)list.get(8)).getRlpData());
        this.groupId = BaseFixedSizeByteArray.Fixed20ByteArray.valueOf((byte[])((RlpElement)list.get(9)).getRlpData());
        this.version = ByteUtils.bytesToShort((byte[])((RlpElement)list.get(10)).getRlpData());
        this.data = ((RlpElement)list.get(11)).getRlpData();
        RlpList sigList = (RlpList)list.get(12);
        for (RlpElement element : sigList) {
            this.signatureList.add(element.getRlpData());
        }
        RlpList extList = (RlpList)list.get(13);
        for (RlpElement element : extList) {
            Extension item = new Extension();
            item.fromRlp((RlpList)element);
            this.extensions.add(item);
        }
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("hash", (Object)ByteUtils.toHexString((byte[])this.hash.getValue()));
        jsonObject.put("type", (Object)this.txType.getValue());
        jsonObject.put("timestamp", (Object)this.timestamp);
        jsonObject.put("nonce", (Object)this.nonce.getValue());
        jsonObject.put("period", (Object)this.period);
        jsonObject.put("from", (Object)ByteUtils.toHexString((byte[])this.from.getValue()));
        jsonObject.put("to", (Object)ByteUtils.toHexString((byte[])this.to.getValue()));
        jsonObject.put("value", (Object)this.value.getValue());
        jsonObject.put("gas", (Object)this.gas);
        jsonObject.put("group_id", (Object)ByteUtils.toHexString((byte[])this.groupId.getData()));
        jsonObject.put("version", (Object)this.version);
        jsonObject.put("data", (Object)ByteUtils.toHexString((byte[])this.data));
        JSONArray jsonArray = new JSONArray();
        if (this.signatureList != null) {
            for (byte[] item : this.signatureList) {
                jsonArray.add((Object)ByteUtils.toHexString((byte[])item));
            }
        }
        jsonObject.put("signature", (Object)jsonArray);
        JSONArray extArray = new JSONArray();
        if (this.extensions != null) {
            for (Extension item : this.extensions) {
                JSONObject object = item.toJson();
                extArray.add((Object)object);
            }
        }
        jsonObject.put("extensions", (Object)extArray);
        return jsonObject;
    }

    @Override
    public TransactionModel fromJson(JSONObject jsonObject) {
        JSONArray extArray;
        this.hash = new Hash(jsonObject.getString("hash"));
        this.txType = TransactionType.forNumber(jsonObject.getInteger("type"));
        this.timestamp = jsonObject.getLong("timestamp");
        this.nonce = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf((BigInteger)jsonObject.getBigInteger("nonce"));
        this.period = jsonObject.getLong("period");
        this.from = new Identity(jsonObject.getString("from"));
        this.to = new Identity(jsonObject.getString("to"));
        this.value = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf((BigInteger)jsonObject.getBigInteger("value"));
        this.gas = jsonObject.getBigInteger("gas");
        this.groupId = BaseFixedSizeByteArray.Fixed20ByteArray.valueOf((byte[])ByteUtils.hexStringToBytes((String)jsonObject.getString("group_id")));
        this.version = jsonObject.getShort("version");
        this.data = ByteUtils.hexStringToBytes((String)jsonObject.getString("data"));
        JSONArray sigArray = jsonObject.getJSONArray("signature");
        if (sigArray != null) {
            for (Object o : sigArray) {
                this.signatureList.add(ByteUtils.hexStringToBytes((String)((String)o)));
            }
        }
        if ((extArray = jsonObject.getJSONArray("extensions")) != null) {
            for (Object o : extArray) {
                Extension object = new Extension();
                object.fromJson((JSONObject)o);
                this.extensions.add(object);
            }
        }
        return this;
    }

    public String toString() {
        return "TransactionModel{txType=" + (Object)((Object)this.txType) + ", data=" + (this.data == null ? null : Hex.toHexString((byte[])this.data)) + ", signatureList=" + (this.signatureList == null ? null : "[" + this.signatureList.stream().map(Hex::toHexString).collect(Collectors.joining(", ")) + "]") + ", hash=" + (this.hash == null ? null : this.hash.hexStrValue()) + ", from=" + (this.from == null ? null : this.from.hexStrValue()) + ", to=" + (this.to == null ? null : this.to.hexStrValue()) + ", timestamp=" + this.timestamp + ", period=" + this.period + ", nonce=" + this.nonce + ", gas=" + this.gas + ", blockNumber=" + this.blockNumber + ", value=" + this.value + ", extensions=" + this.extensions + ", groupId=" + this.groupId + ", version=" + this.version + '}';
    }
}

